/****************************************************************************
    $Id: strings.h 501.0 1995/03/07 12:26:46 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declaration of class TLString. This class represents a character string,
    i.e. a sequence of characters, terminated by '\0'. The string can be
    instructed to retain its capacity, or to resize itself each time an
    expansion is necessary.

    Character indexing starts at 0, just as with C-style strings.

    $Log: strings.h $
    Revision 501.0  1995/03/07 12:26:46  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:29:26  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1994/10/05  18:24:56  ron
    Renamed TLx...() functions to tl...()

    Revision 1.5  1994/09/28  14:29:14  ron
    Removed Macintosh-style #include references

    Revision 1.4  1994/09/27  20:25:43  ron
    Changed path separator from / to \

    Revision 1.3  1994/09/26  15:22:34  ron
    Renamed SetSize() to Resize()

    Revision 1.2  1994/09/06  13:59:10  ron
    Adapted to changes in tlx.h

    Revision 1.1  1994/08/16  18:06:53  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_STRINGS_H
#define _TLX_STRINGS_H

//-----	System headers

//-----	Project headers

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

class _RTLCLASS ostream;

/*---------------------------------------------------------------------------
    TLString -

    This class represents a character string, i.e. a sequence of characters
    of known length. It stores the characters in an internal buffer,
    and expands the buffer if necessary. The buffer is only contracted on
    request.
---------------------------------------------------------------------------*/

class _TLXCLASS TLString
{
    char *		mString;	// Actual contents
    size_t		mSize;		// Buffer size
    size_t 		mLen;		// Logical string length

public:
    // Constructors and destructor

    TLString(size_t = 0);
    TLString(char, size_t = 0);
    TLString(const char *, size_t = 0);
    TLString(const TLString &);
    ~TLString();

    // Assignment operators

    TLString &		operator =(char);
    TLString &		operator =(const char *);
    TLString &		operator =(const TLString &);
    TLString &		operator +=(char);
    TLString &		operator +=(const char *);
    TLString &		operator +=(const TLString &);

    // Conversion operators
    			operator char *() { return mString; }
    			operator const char *() const { return mString; }
    			operator char() const { return *mString; }
    int 		operator !() const { return mLen == 0; }

    // Access to individual characters

    char &		operator [](size_t);
    char 		operator [](size_t) const;
    char &		PeekAt(size_t i) { return mString[i]; }
    char 		PeekAt(size_t i) const { return mString[i]; }

    // Modifications to the string's contents

    void 		Clear();
    void 		ToLower();
    void 		ToUpper();
    void 		Reverse();

    // Substring insertion & extraction

    void 		Fill(char, size_t = 0, size_t = kMaxAlloc);
    void 		Append(char c) { Insert(c, mLen); }
    void 		Append(const char *s) { Insert(s, mLen); }
    void 		Append(const TLString &s) { Insert(s, mLen); }
    void 		Insert(char, size_t);
    void 		Insert(const char *, size_t);
    void 		Insert(const TLString &, size_t);
    void 		Prepend(char c) { Insert(c, 0); }
    void 		Prepend(const char *s) { Insert(s, 0); }
    void 		Prepend(const TLString &s) { Insert(s, 0); }
    void 		Remove(size_t, size_t);
    TLString 		Copy(size_t, size_t);
    TLString 		Extract(size_t, size_t);

    // String searching

    size_t 		IndexOf(char, size_t = 0);
    size_t 		IndexOf(const char *, size_t = 0);
    size_t 		IndexOf(const TLString &, size_t = 0);

    // Length & integrity functions

    void 		CompactStorage();
    size_t 		Length() const { return mLen; }
    size_t 		Size() const { return mSize; }
    void		Reserve(size_t);
    static size_t 	MaxSize() { return kMaxAlloc - 1; }
    void 		Sync();
    void		Terminate();
    bool 		IsValidIndex(size_t aIndex) const
    			    { return aIndex < mLen; }

    // Comparison operators

    friend int _TLXFUNC	operator ==(const TLString &, const TLString &);
    friend int _TLXFUNC operator ==(const TLString &, const char *);
    friend int _TLXFUNC operator ==(const char *, const TLString &);
    friend int _TLXFUNC	operator !=(const TLString &, const TLString &);
    friend int _TLXFUNC operator !=(const TLString &, const char *);
    friend int _TLXFUNC operator !=(const char *, const TLString &);
    friend int _TLXFUNC	operator <=(const TLString &, const TLString &);
    friend int _TLXFUNC operator <=(const TLString &, const char *);
    friend int _TLXFUNC operator <=(const char *, const TLString &);
    friend int _TLXFUNC	operator < (const TLString &, const TLString &);
    friend int _TLXFUNC operator < (const TLString &, const char *);
    friend int _TLXFUNC operator < (const char *, const TLString &);
    friend int _TLXFUNC	operator >=(const TLString &, const TLString &);
    friend int _TLXFUNC operator >=(const TLString &, const char *);
    friend int _TLXFUNC operator >=(const char *, const TLString &);
    friend int _TLXFUNC	operator > (const TLString &, const TLString &);
    friend int _TLXFUNC operator > (const TLString &, const char *);
    friend int _TLXFUNC operator > (const char *, const TLString &);

    friend ostream & _TLXFUNC operator <<(ostream &, const TLString &);
    friend void _TLXFUNC tlSwap(TLString &, TLString &);

private:
    TLString &		Assign(const char *, size_t);
    TLString &		Append(const char *, size_t);
    void 		Create(const char *, size_t, size_t);
    void 		Insert(const char *, size_t, size_t);
    void		Resize(size_t);
};

#endif	// _TLX_STRINGS_H

