/****************************************************************************
    $Id: xstdio.cpp 501.0 1995/03/07 12:26:30 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of class TLXStdio.

    $Log: xstdio.cpp $
    Revision 501.0  1995/03/07 12:26:30  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:30:40  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1995/01/06  15:59:12  ron
    Corrected Revision keyword

    Revision 1.1  1994/11/16  15:47:40  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <errno.h>              // For errno
#include <stdio.h>              // For sprintf()
#include <string.h>             // For strerror()
#include <tlx\501\except.h>

/*-------------------------------------------------------------------------*/
    TLXStdio::TLXStdio(const TLXLocus &aLocus, const char *aFile)

/*  Constructor. Initializes the data members and base class.
---------------------------------------------------------------------------*/
: TLException(aLocus), mErrNo(errno), mFileName(aFile)
{
}

/*-------------------------------------------------------------------------*/
    const char *TLXStdio::Description() const

/*  Builds a description of the exception and returns a pointer to it.
    The exception is built in the static buffer provided by class
    TLException.
---------------------------------------------------------------------------*/
{
    sprintf(sBuffer, "Stdio error in %s: %s", mFileName, strerror(mErrNo));
    return sBuffer;
}

