/****************************************************************************
    $Id: xios.cpp 501.0 1995/03/07 12:26:30 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of class TLXIos.

    $Log: xios.cpp $
    Revision 501.0  1995/03/07 12:26:30  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:30:38  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1995/01/06  15:59:07  ron
    Corrected Revision keyword

    Revision 1.1  1994/11/16  15:47:07  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <stdio.h>              // For sprintf()
#include <tlx\501\except.h>

/*-------------------------------------------------------------------------*/
    TLXIos::TLXIos(const TLXLocus &aLocus, const ios &s)

/*  Constructor. Initializes the data members and base class.
---------------------------------------------------------------------------*/
: TLException(aLocus), mErrState(CONSTCAST(ios &,s).rdstate())
{
    // Note: the previous CONSTCAST should not have been necessary if all
    // implementations would have declared ios::rdstate() as const, which it
    // really is...
}

/*-------------------------------------------------------------------------*/
    const char *TLXIos::Description() const

/*  Builds a description of the exception and returns a pointer to it.
    The exception is built in the static buffer provided by class
    TLException.
---------------------------------------------------------------------------*/
{
    const char *iostate;

    if (mErrState == 0)
    	iostate = "No error";
    if (mErrState & ios::eofbit)
	iostate = "EOF";
    else if (mErrState & ios::badbit)
	iostate = "Bad state";
    else if (mErrState & ios::failbit)
	iostate = "Failed";
    else
	iostate = "Unknown";

    sprintf(sBuffer, "IOStream error: %s", iostate);
    return sBuffer;
}
