/****************************************************************************
    $Id: xalloc.cpp 501.0 1995/03/07 12:26:30 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of class TLXAlloc.

    $Log: xalloc.cpp $
    Revision 501.0  1995/03/07 12:26:30  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:30:36  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1995/01/06  15:59:02  ron
    Corrected Revision keyword

    Revision 1.1  1994/11/16  15:46:33  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <stdio.h>              // For sprintf()
#include <tlx\501\except.h>

/*-------------------------------------------------------------------------*/
    TLXAlloc::TLXAlloc(const TLXLocus &aLocus, size_t aSize)

/*  Constructor. Initializes the data members and base class.
---------------------------------------------------------------------------*/
: TLException(aLocus), mSize(aSize)
{
}

/*-------------------------------------------------------------------------*/
    const char *TLXAlloc::Description() const

/*  Builds a description of the exception and returns a pointer to it.
---------------------------------------------------------------------------*/
{
    sprintf(sBuffer, "Memory allocation of %u bytes failed", mSize);
    return sBuffer;
}

