/****************************************************************************
    $Id: vpstack.cpp 501.0 1995/03/07 12:26:28 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLVPStack.

    $Log: vpstack.cpp $
    Revision 501.0  1995/03/07 12:26:28  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:30:34  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1995/01/06  15:58:57  ron
    Corrected Revision keyword

    Revision 1.5  1994/11/16  15:46:15  ron
    Added module info; rearranged #include directives

    Revision 1.4  1994/09/28  14:48:00  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:23:35  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:52:01  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:24  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <string.h>		// For memcpy(), memmove()
#include <tlx\501\except.h>		// Exception handling
#include <tlx\501\vparrays.h>	// Class declaration

/*-------------------------------------------------------------------------*/
    TLVPStack::TLVPStack(size_t aSize, size_t aDelta)

/*  Conctructor, creates a stack of specific initial capacity and
    expansion factor. Also doubles as default constructor, creating
    and empty and nonexpandable stack.
---------------------------------------------------------------------------*/
: mSeq(aSize, aDelta)
{
    TLX_ASSERT(Size() == aSize);
}

/*-------------------------------------------------------------------------*/
    TLVPStack::TLVPStack(void *aPtr)

/*  Creates a single element stack that is not expandable.
---------------------------------------------------------------------------*/
: mSeq(aPtr)
{
    TLX_ASSERT(Size() == 1);
}

/*-------------------------------------------------------------------------*/
    TLVPStack::TLVPStack(void **aVector, size_t aSize)

/*  Creates a stack that contains a copy of a C-style vector. The stack is
    not expandable initially.
---------------------------------------------------------------------------*/
: mSeq(aVector, aSize)
{
    TLX_ASSERT(Size() == aSize);
}

/*-------------------------------------------------------------------------*/
    TLVPStack::TLVPStack(const TLVPStack &aStack)

/*  Copy constructor. Creates a copy of another stack.
---------------------------------------------------------------------------*/
: mSeq(aStack.mSeq)
{
    TLX_ASSERT(Size() == aStack.Size());
}

/*-------------------------------------------------------------------------*/
    TLVPStack &TLVPStack::operator =(const TLVPStack &aStack)

/*  Overloading of assignment operator for class TLVPStack. The overloading
    is not really necessary (the compiler generated version would work as
    well), but is useful for extra tests and breakpoints.
---------------------------------------------------------------------------*/
{
    if (TLX_CHECK(this != &aStack))
	mSeq = aStack.mSeq;

    return *this;
}

/*-------------------------------------------------------------------------*/
    TLVPStack &TLVPStack::operator =(void *aPtr)

/*  Overloading of assignment operator that allows a single pointer to be
    assigned to the stack. The stack consists of a single element
    afterwards.

    NOTE: If the current stack has currently a physical size of zero and is
    not allowed to expand, this function fails.
---------------------------------------------------------------------------*/
{
    RemoveAll();
    Push(aPtr);

    TLX_ASSERT(Size() == 1);
    TLX_ASSERT(PeekTop() == aPtr);

    return *this;
}
