/****************************************************************************
    $Id: vpset.cpp 501.0 1995/03/07 12:26:28 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLVPSet.

    $Log: vpset.cpp $
    Revision 501.0  1995/03/07 12:26:28  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:30:34  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1995/01/06  15:58:56  ron
    Corrected Revision keyword

    Revision 1.5  1994/11/16  15:46:10  ron
    Added module info; rearranged #include directives

    Revision 1.4  1994/09/28  14:47:53  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:23:34  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:51:53  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:23  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\except.h>		// Exception handling
#include <tlx\501\vparrays.h>	// Class declaration

/*-------------------------------------------------------------------------*/
    TLVPSet::TLVPSet(size_t aSize, size_t aDelta)

/*  Constructor, creates a set of specific initial capacity and expansion
    factor. Also doubles as default constructor, creating and empty and
    nonexpandable set.
---------------------------------------------------------------------------*/
: mSeq(aSize, aDelta)
{
    TLX_ASSERT(Size() == aSize);
}

/*-------------------------------------------------------------------------*/
    TLVPSet::TLVPSet(void *aPtr)

/*  Constructor, creating a single element set that is not expandable.
---------------------------------------------------------------------------*/
: mSeq(aPtr)
{
    TLX_ASSERT(Size() == 1);
}

/*-------------------------------------------------------------------------*/
    TLVPSet::TLVPSet(void **aVector, size_t aSize)

/*  Constructor, creating a set that contains a copy of a C-style vector.
    The set is not expandable initially.
---------------------------------------------------------------------------*/
: mSeq(aVector, aSize)
{
    TLX_ASSERT(Size() == aSize);
}

/*-------------------------------------------------------------------------*/
    TLVPSet::TLVPSet(const TLVPSet &aSet)

/*  Copy constructor. Creates a copy of another set.
---------------------------------------------------------------------------*/
: mSeq(aSet.mSeq)
{
    TLX_ASSERT(Size() == aSet.Size());
}
#if 0
/*-------------------------------------------------------------------------*/
    void *&TLVPSet::PeekIter(index_t aIndex)

/*  Returns a reference to the current iterator element.
---------------------------------------------------------------------------*/
{
    return mSeq[aIndex];	// Will test index validity
}

/*-------------------------------------------------------------------------*/
    void *TLVPSet::PeekIter(index_t aIndex) const

/*  Returns the value of the current iterator element.
---------------------------------------------------------------------------*/
{
    return mSeq[aIndex];	// Will test index validity
}

/*-------------------------------------------------------------------------*/
    bool TLVPSet::IterStart(index_t &aIndex) const

/*  Resets set iterator, returning nonzero if the iterator is valid after
    the operation.
---------------------------------------------------------------------------*/
{
    aIndex = mSeq.Mini();
    return !mSeq.IsEmpty();
}

/*-------------------------------------------------------------------------*/
    bool TLVPSet::IterNext(index_t &aIndex) const

/*  Advances the set iterator to the next element in the set, returning
    nonzero if the iterator is valid after the operation.
---------------------------------------------------------------------------*/
{
    aIndex++;
    return mSeq.IsValidIndex(aIndex);
}
#endif
