/****************************************************************************
    $Id: varselct.cpp 501.0 1995/03/07 12:26:26 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of several TLVarSelector classes.

    $Log: varselct.cpp $
    Revision 501.0  1995/03/07 12:26:26  RON
    Updated for TLX 5.01
    Revision 1.4  1995/02/22 12:23:10  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
//Revision 1.3  1995/01/16  12:26:44  ron
//Added subproblem parameter to varselectors
//
//Revision 1.2  1995/01/12  13:42:20  ron
//Adapted to previous Searcher/ProblemRep model
//
//Revision 1.1  1995/01/06  15:58:43  ron
//Corrected Revision keyword
//
****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <stdlib.h>

#include <tlx\501\solve\stdcsp.h>

#if defined(__IBMCPP__) || defined(_MSC_VER) || defined(__WATCOMC__)
    // IBM, Microsoft, Watcom C++ have no random(int) function

    inline int random(int __num)
    	{ return(int)(((long)rand()*__num)/(RAND_MAX+1)); }
#endif

/*-------------------------------------------------------------------------*/
    TLVarSelector::~TLVarSelector()

/*  Destructor. Does nothing, but is declared virtual for derivation.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    TLVSRandom::TLVSRandom()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSRandom::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "Random order";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSRandom::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking one pseudo-randomly from the given list.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    index_t rindex = random(aList.Count());
    return aList[rindex + 1];
}

/*-------------------------------------------------------------------------*/
    TLVSSmallestDomain::TLVSSmallestDomain()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSSmallestDomain::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "Smallest domain first";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSSmallestDomain::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking the (first) one with the smallest domain.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    TLVariable *v = aList.PeekFirst();
    size_t dsize   = v->DomainSize();

    for (index_t i = aList.Mini() + 1; i <= aList.Maxi(); i++)
    {
	TLVariable *var = aList.PeekAt(i);
	TLX_ASSERT_PTR(var);

	if (var->DomainSize() < dsize)
	{
	    v 	  = var;
	    dsize = v->DomainSize();
	}
    }
    return v;
}

/*-------------------------------------------------------------------------*/
    TLVSLargestDomain::TLVSLargestDomain()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSLargestDomain::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "Largest domain first";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSLargestDomain::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking the (first) one with the largest domain.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    TLVariable *v = aList.PeekFirst();
    size_t dsize   = v->DomainSize();

    for (index_t i = aList.Mini() + 1; i <= aList.Maxi(); i++)
    {
	TLVariable *var = aList.PeekAt(i);
	TLX_ASSERT_PTR(var);

	if (var->DomainSize() > dsize)
	{
	    v 	  = var;
	    dsize = v->DomainSize();
	}
    }
    return v;
}

/*-------------------------------------------------------------------------*/
    TLVSMostConstrained::TLVSMostConstrained()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSMostConstrained::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "Most constrained first";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSMostConstrained::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking the (first) one with the most constraints.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    TLVariable *v = aList.PeekFirst();
    size_t ccnt 	  = v->ConstraintCount();

    for (index_t i = aList.Mini() + 1; i <= aList.Maxi(); i++)
    {
	TLVariable *var = aList.PeekAt(i);
	TLX_ASSERT_PTR(var);

	if (var->ConstraintCount() > ccnt)
	{
	    v 	 = var;
	    ccnt = v->ConstraintCount();
	}
    }
    return v;
}

/*-------------------------------------------------------------------------*/
    TLVSLeastConstrained::TLVSLeastConstrained()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSLeastConstrained::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "Least constrained first";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSLeastConstrained::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking the (first) one with the least constraints.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    TLVariable *v = aList.PeekFirst();
    size_t ccnt 	  = v->ConstraintCount();

    for (index_t i = aList.Mini() + 1; i <= aList.Maxi(); i++)
    {
	TLVariable *var = aList.PeekAt(i);
	TLX_ASSERT_PTR(var);

	if (var->ConstraintCount() < ccnt)
	{
	    v 	 = var;
	    ccnt = v->ConstraintCount();
	}
    }
    return v;
}

/*-------------------------------------------------------------------------*/
    TLVSDomConMix::TLVSDomConMix()

/*  Constructor. Provided for completeness only.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLVSDomConMix::Description() const

/*  Returns a description of the selection strategy.
---------------------------------------------------------------------------*/
{
    return "|C| / (|D|^2)";
}

/*-------------------------------------------------------------------------*/
    TLVariable *TLVSDomConMix::SelectVariable(
	TLCSProblemState *,
    	TLCSProblemRep *,
	const TLVarList &aList)

/*  Selects a variable by picking the (first) one with the most constraints.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!aList.IsEmpty());

    TLVariable *v   = aList.PeekFirst();
    size_t dsize     = v->DomainSize();
    size_t maxweight = (dsize > 0) ? v->ConstraintCount() /
	    	      (dsize * dsize) : kMaxSize;

    for (index_t i = aList.Mini() + 1; i <= aList.Maxi(); i++)
    {
	TLVariable *var = aList.PeekAt(i);
	TLX_ASSERT_PTR(var);

	dsize 	= var->DomainSize();
	size_t w = (dsize > 0) ? v->ConstraintCount() /
	    	  (dsize * dsize) : kMaxSize;

	if (w > maxweight)
	{
	    v 	      = var;
	    maxweight = w;
	}
    }
    return v;
}

