/****************************************************************************
    $Id: varac6.cpp 501.0 1995/03/07 12:26:26 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLVariableAC6.

    $Log: varac6.cpp $
    Revision 501.0  1995/03/07 12:26:26  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:32  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:58:40  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:45:35  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:56:57  ron
    Changed to <tlx\solve\ac6.h>

    Revision 1.4  1994/09/28  14:47:05  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:23:20  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:50:11  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:20  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\ac6.h>

/*-------------------------------------------------------------------------*/
    TLVariableAC6::TLVariableAC6(const char *aName, size_t aCap)

/*  Constructor. Creates a domain with a given initial capacity.
---------------------------------------------------------------------------*/
: TLVariable(aName), mDomain(aCap, 50)
{
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::AddSupport(tVarValue aValue, const VV_Assoc &aVV)

/*  Adds the given variable/value pair to the support list of the given
    domain value.
---------------------------------------------------------------------------*/
{
    TLDomainElement &el = mDomain.GetElement(aValue);
    el.AddSupport(aVV);
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::AddValue(tVarValue aValue)

/*  Adds a value and an empty support list to the domain of the variable.
---------------------------------------------------------------------------*/
{
    mDomain.Append(TLDomainElement(aValue));
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::ClearSupport()

/*  Clears all support lists of all values in the domain.
---------------------------------------------------------------------------*/
{
    for (index_t i = mDomain.Mini(); i <= mDomain.Maxi(); i++)
	mDomain.PeekAt(i).ClearSupport();
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::DiscardDomain(void *aDom)

/*  Discards a domain that was previously created by SaveDomain().
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aDom);
    delete (TLDomainAC6 *)aDom;
}

/*-------------------------------------------------------------------------*/
    TLConstraintAC6 *TLVariableAC6::FindConstraintTo
    (
    	const TLVariableAC6 *	aVar
    ) const

/*  Looks through all constraints connected to the variable to find the
    (first) one that is connected to the given variable.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aVar);

    // We assume that all constraints are of type TLConstraintAC6 or
    // derived thereof.

    for (index_t i = Constraints().Mini(); i <= Constraints().Maxi(); i++)
    {
	TLConstraintAC6 *con = DYNACAST(TLConstraintAC6 *,
					Constraints().PeekAt(i));
	TLX_ASSERT_PTR(con);

	if (&((const TLConstraintAC6 *)con)->OppositeOf(*this) == aVar)
	    return con;
    }
    return 0;
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::RemoveSupport(tVarValue aValue, const VV_Assoc &aVV)

/*  Removes the given variable/value pair from the support list of the
    given domain value.
---------------------------------------------------------------------------*/
{
    TLDomainElement &el = mDomain.GetElement(aValue);
    el.RemoveSupport(aVV);
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::RemoveValue(tVarValue aValue)

/*  Removes a value (and its support list) from the domain of the variable.
---------------------------------------------------------------------------*/
{
    mDomain.Remove(TLDomainElement(aValue));
}

/*-------------------------------------------------------------------------*/
    void TLVariableAC6::RestoreDomain(void *aDom)

/*  Restores a domain that was previously saved by SaveDomain().
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aDom);
    mDomain = *(TLDomainAC6 *)aDom;
}

/*-------------------------------------------------------------------------*/
    void *TLVariableAC6::SaveDomain()

/*  Saves the domain by creating and returning a copy of it.
---------------------------------------------------------------------------*/
{
    return new TLDomainAC6(mDomain);
}

