/****************************************************************************
    $Id: tlx.cpp 501.0 1995/03/07 12:26:24 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLX.

    $Log: tlx.cpp $
    Revision 501.0  1995/03/07 12:26:24  RON
    Updated for TLX 5.01
    Revision 1.14  1995/01/31 16:30:30  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.13  1995/01/18  19:03:52  ron
    Added indication of GUI/Console application

    Revision 1.12  1995/01/06  15:58:37  ron
    Corrected Revision keyword

    Revision 1.11  1995/01/05  15:30:32  ron
    Formatting changes in descriptive output

    Revision 1.10  1994/11/16  15:44:18  ron
    Changed format of description output
    Adapted to use of _CCNAME, _CCVER, and _MODEL macros
    Added module info; rearranged #include directives

    Revision 1.9  1994/10/11  19:05:07	ron
    Enlarged buffer size for description

    Revision 1.8  1994/10/10  16:56:32	ron
    Changed layout of library description
    Added maturity indication

    Revision 1.7  1994/10/05  18:44:36	ron
    Added support for Watcom C++
    Added more accurate build date/time stamp

    Revision 1.6  1994/09/28  14:23:12	ron
    Changed contents and layout of library description string

    Revision 1.5  1994/09/27  20:23:15	ron
    Changed path separator from / to \

    Revision 1.4  1994/09/26  15:49:28	ron
    Various changes to version macros

    Revision 1.3  1994/09/08  15:58:07	ron
    Added link time checks for DLL vs. static version

    Revision 1.2  1994/09/07  15:44:25	ron
    Implemented link-detection functions
    Added support for DOS extender platforms

    Revision 1.1  1994/08/16  18:13:18	ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <stdio.h>
#include <string.h>

#if defined(__SC__)
    // Symantec C++ bug fix
    const char *sPre     = "[";
    const char *sPreSep  = "";
    const char *sPostSep = ", ";
    const char *sPost    = "]";
#endif

/*---------------------------------------------------------------------------
    Version-dependent implementations of TLX member functions
---------------------------------------------------------------------------*/

int TLX::_TLXVNAME() { return _TLXVER; }
int TLX::_TLXDS() { return 0; }
int TLX::_TLXDR() { return 0; }

/*-------------------------------------------------------------------------*/
    const char * TLX::Compiler()

/*  Returns a description of the compiler that was used to compile TLX.
---------------------------------------------------------------------------*/
{
    return STR(_CCNAME) " " STR(_CCVER);
}

#if defined(_MSC_VER) && _MSC_VER < 1011
// MSVC++ 4.1 internal compiler error
#pragma optimize( "g", off)
#endif

/*-------------------------------------------------------------------------*/
    const char * TLX::Description()

/*  Returns a formatted description of the compilation platform,
---------------------------------------------------------------------------*/
{
    const BUFSIZE = 512;
    static char buffer[BUFSIZE];

    sprintf(buffer,
	    "Tarma Library for C++, Edition 5.x\n"
	    "Copyright (c) 1991-95 Tarma Software Research. "
	    "All rights reserved.\n\n"
	    "Revision : " STR(_TLXMAJ) "." STR(_TLXMIN) "." STR(_TLXREV) "\n"
	    "Config   : " STR(_TLXDS) ", " STR(_TLXDR) "\n"
	    "Maturity : %s\n"
	    "Platform : %s, model=%s, "
	  #ifdef _GUI
	    "GUI"
	  #else
	    "Console"
	  #endif
	    " application\n"
	    "Compiler : %s\n"
	    "Built on : %s\n",
	    Maturity(), Platform(), Model(), Compiler(), TimeStamp());

    TLX_ASSERT(strlen(buffer) < BUFSIZE);
    return buffer;
}

#if defined(_MSC_VER) && _MSC_VER < 1011
#pragma optimize( "", on)
#endif

/*-------------------------------------------------------------------------*/
    bool TLX::IsDebug()

/*  Returns nonzero if this is the debugging version of TLX, else zero.
---------------------------------------------------------------------------*/
{
  #ifdef _TLXDBG
    return true;
  #else
    return false;
  #endif
}

/*-------------------------------------------------------------------------*/
    const char *TLX::Maturity()

/*  Returns the maturity level of the library release.
---------------------------------------------------------------------------*/
{
#ifdef PROJLEVEL
    return STR(PROJLEVEL);
#else
    return "(Unknown - assume experimental)";
#endif
}

/*-------------------------------------------------------------------------*/
    const char *TLX::Model()

/*  Returns a description of the compilation memory model.
---------------------------------------------------------------------------*/
{
    return
    #ifdef _MEM_SEG
	"Segmented,"
    #endif
    STR(_MODEL);
}

/*-------------------------------------------------------------------------*/
    const char *TLX::Platform()

/*  Returns a description of the compilation platform.
---------------------------------------------------------------------------*/
{
    #if OS_BSD
	return "BSD Unix";
    #elif OS_DOS
	return "MS/PC-DOS, real mode";
    #elif OS_DOS286
	return "MS/PC-DOS, 16-bit protected";
    #elif OS_DOS386
	return "MS/PC-DOS, 32-bit protected";
    #elif OS_MAC
	return "Apple Macintosh";
    #elif OS_OS2
	return "OS/2 2.x";
    #elif OS_SCO
	return "SCO Unix";
    #elif OS_SV4
	return "System V4 Unix";
    #elif OS_UNX
	return "Generic Unix";
    #elif OS_WIN16
	return "Windows 16-bit";
    #elif OS_WIN32
	return "Windows 32-bit";
    #elif OS_WIN32S
	return "Windows 32-bit subset";
    #else
	return "**Unknown platform**";
    #endif
}

/*-------------------------------------------------------------------------*/
    const char *TLX::TimeStamp()

/*  Returns the date/time stamp of the library build.
---------------------------------------------------------------------------*/
{
    return sTimeStamp;
}

/*-------------------------------------------------------------------------*/
    word_t TLX::Version()

/*  Returns the TLX version number, encoded hexadecimally.
---------------------------------------------------------------------------*/
{
    return _TLXVER;
}

