/****************************************************************************
    $Id: swaps.cpp 501.0 1995/03/07 12:26:24 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of byte-swapping functions:

    - tlSwap16(int16)
    - tlSwap32(int32)

    $Log: swaps.cpp $
    Revision 501.0  1995/03/07 12:26:24  RON
    Updated for TLX 5.01
    Revision 1.10  1995/02/28 15:14:28  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.9  1995/01/18  19:03:29  ron
    Added inline assembly warning for Win32

    Revision 1.8  1995/01/06  15:58:35  ron
    Corrected Revision keyword

    Revision 1.7  1994/11/16  15:44:10  ron
    Added module info; rearranged #include directives

    Revision 1.6  1994/10/07  17:06:11  ron
    Changed WATCOM support

    Revision 1.5  1994/10/05  18:44:08  ron
    Added generic implementations of the swap functions

    Revision 1.4  1994/09/28  14:46:45  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:23:13  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:49:04  ron
    Added support for DOS-extended platforms

    Revision 1.1  1994/08/16  18:13:17  ron
    Initial revision

****************************************************************************/

#if defined(__BORLANDC__) && (defined(__OS2__) || defined(__WIN32__))
  #pragma inline		// Warn compiler for inline assembly for OS/2
  #if __BORLANDC__ <= 0x460	// BC++ OS/2 v1.5 bug work around
    #define _NO_LINK_CHECK	// Do not include global objects
    #define NMODINFO	1
  #endif
#endif

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

//-----	System headers

#if defined(__IBMC__) || defined(__IBMCPP__)
#include <stdlib.h>		// For _swab()
#endif

#if defined(__BORLANDC__)
#pragma warn -rvl		// Disable "function should return a value"
#elif defined(_MSC_VER)
#pragma warning(disable: 4035)	// Disable "function has no return value"
#elif defined(__WATCOMC__) || defined(__SUNPRO_CC)
#define USE_GENERIC
#endif

/*-------------------------------------------------------------------------*/
    int16 _TLXFUNC tlSwap16(int16 aInt)

/*  Swaps 2 bytes in a 16-bit integer. Returns the swapped value.

    NOTE: Ignore compiler warnings about function not returning a value.
    The value is returned alright, but the compiler doesn't know.
---------------------------------------------------------------------------*/
{
#ifdef USE_GENERIC
    int16 result;
    WORD_LSB(result) = WORD_MSB(aInt);
    WORD_MSB(result) = WORD_LSB(aInt);
    return result;
#else
  #if OS_DOS	// Assumes Intel 80x86 processor

    __asm {
	mov	ax,word ptr aInt
	mov	cl,8		/* rol ax,8 is only for 80286 and later */
	rol	ax,cl
	// Fall through with the result in AX
    }

  #elif OS_DOS286 || OS_DOS386 || OS_WIN16	// 80286 or better

    __asm {
	mov	ax,word ptr aInt
	rol	ax,8
	// Fall through with the result in AX
    }

  #elif OS_WIN32 || OS_WIN32S	// Assumes Intel 80386 or better

    __asm {
	mov	ax,word ptr aInt
	rol	ax,8
	// Fall through with the result in AX
    }
    TLX_TODO(Check passing of return value);

  #elif OS_OS2	// Assumes Intel 80386 or better

  #if defined(__BORLANDC__)
    __asm {
	mov	ax,word ptr aInt
	rol	ax,8
	// Fall through with the result in AX
    }
    TLX_TODO(Check passing of return value);

  #elif defined(__IBMC__) || defined(__IBMCPP__)
    int16 result;
    _swab((char *)&aInt, (char *)&result, sizeof(int16));
    return result;
  #else
    #error Unsupported compiler; contact Tarma Software Research
  #endif

  #elif OS_MAC	// Assumes Motorola 68k processor

    asm {
	MOVE.W	 aInt(A6),D0
	ROL.W	 #8,D0
	// Fall through with the result in D0
    }
  #else
    #error Unsupported platform; contact Tarma Software Research
  #endif
#endif	// USE_GENERIC
}

/*-------------------------------------------------------------------------*/
    int32 _TLXFUNC tlSwap32(int32 aInt)

/*  Swaps 4 bytes in a 32-bit integer. Bytes 0 and 3 are swapped, as are
    bytes 1 and 2. Returns the swapped value.

    NOTE: Ignore compiler warnings about function not returning a value.
    The value is returned alright, but the compiler doesn't know.
---------------------------------------------------------------------------*/
{
#ifdef USE_GENERIC
    int32 result;
    DWORD_B0(result) = DWORD_B3(aInt);
    DWORD_B1(result) = DWORD_B2(aInt);
    DWORD_B2(result) = DWORD_B1(aInt);
    DWORD_B3(result) = DWORD_B0(aInt);
    return result;
#else
  #if OS_DOS      // Assumes Intel 80x86 processor

    __asm {
	mov	ax,word ptr aInt
	mov	dx,word ptr aInt+2
	mov	cl,8		/*  rol ax,8 is only for 80286 and later */
	rol	ax,cl
	rol	dx,cl
	xchg	ax,dx
	// Fall through with the result in DX:AX
    }

  #elif OS_DOS286 || OS_DOS386 || OS_WIN16	// 80286 or better

    __asm {
	mov	ax,word ptr aInt
	mov	dx,word ptr aInt+2
	rol	ax,8
	rol	dx,8
	xchg	ax,dx
	// Fall through with the result in DX:AX
    }

  #elif OS_WIN32 || OS_WIN32S	// Assumes Intel 80386 or better

    __asm {
	mov	ax,word ptr aInt
	mov	dx,word ptr aInt+2
	rol	ax,8
	rol	dx,8
	xchg	ax,dx

        // Fall through with the result in DX:AX

	// The following would be possible on an Intel i486 processor:
	//
	//  mov		eax,dword ptr aInt
	//  bswap	eax
	//
	// But we cannot infer its existence from the compilation pass.
    }
    TLX_TODO(Check passing of return value);

  #elif OS_OS2	// Assumes Intel 80386 or better

  #if defined(__BORLANDC__)
    __asm {
	mov	ax,word ptr aInt
	mov	dx,word ptr aInt+2
	rol	ax,8
	rol	dx,8
	xchg	ax,dx

        // Fall through with the result in DX:AX

	// The following would be possible on an Intel i486 processor:
	//
	//  mov		eax,dword ptr aInt
	//  bswap	eax
	//
	// But we cannot infer its existence from the compilation pass.
    }
    TLX_TODO(Check passing of return value);

  #elif defined(__IBMC__) || defined(__IBMCPP__)
    swap32_u result;
    _swab((char *)&aInt, (char *)&result.words[1], sizeof(int16));
    _swab(((char *)&aInt)+2, (char *)&result.words[0], sizeof(int16));
    return result.dword;
  #else
    #error Unsupported compiler; contact Tarma Software Research
  #endif

  #elif OS_MAC	// Assumes Motorola 68k processor

    asm {
	MOVE.L	aInt(A6),D0
	ROL.W	#8,D0
	SWAP	D0
	ROL.W	#8,D0
	// Fall through with the result in D0
    }
  #else
    #error Unsupported platform; contact Tarma Software Research
  #endif
#endif	// USE_GENERIC
}
