/****************************************************************************
    $Id: strdupnw.cpp 501.0 1995/03/07 12:26:24 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of tlStrDup().

    $Log: strdupnw.cpp $
    Revision 501.0  1995/03/07 12:26:24  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:28  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:58:30  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:43:49  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/05  18:43:22  ron
    Renamed TLx...() functions to tl...()

    Revision 1.4  1994/09/28  14:22:40  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:23:06  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:48:02  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:15  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <string.h>
#include <tlx\501\except.h>		// Exception handling

/*-------------------------------------------------------------------------*/
    char * _TLXFUNC tlStrDup(const char *s, size_t extra)

/*  Same as C/C++ function strdup(), but uses 'operator new' for
    allocations rather than malloc(). This ensures that allocated strings
    can be deleted through 'operator delete' instead of free().

    As an extra, this function allows the specification of a number of
    bytes to allocate in excess of the original string.

    Returns pointer to the newly allocated string.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(s);

    size_t alloclen = strlen(s) + extra + 1;
    char *result   = new char[alloclen];

    if (!result)
	THROW(TLXAlloc(LOCUS, alloclen));

    strcpy(result, s);
    return result;
}
