/****************************************************************************
    $Id: srchwdog.cpp 501.0 1995/03/07 12:26:22 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLSearchWatchdog.

    $Log: srchwdog.cpp $
    Revision 501.0  1995/03/07 12:26:22  RON
    Updated for TLX 5.01
    Revision 1.7  1995/02/22 12:43:06  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1995/01/12  13:41:39  ron
    Added newline to monitor output

    Revision 1.5  1995/01/06  15:58:28  ron
    Corrected Revision keyword

    Revision 1.4  1995/01/05  15:29:50  ron
    Naming and formatting changes

    Revision 1.3  1994/11/16  15:43:44  ron
    Added module info; rearranged #include directives

    Revision 1.2  1994/10/13  11:54:26  ron
    Moved class declaration to searcher.h

    Revision 1.1  1994/10/10  16:55:55  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <iomanip.h>

#include <tlx\501\log.h>
#include <tlx\501\solve\searcher.h>

/*-------------------------------------------------------------------------*/
    TLSearchWatchdog::TLSearchWatchdog(int32 aMaxCount)

/*  Constructor.
---------------------------------------------------------------------------*/
{
    mProblemCount = 0;
    mMaxProblems  = aMaxCount;
}

/*-------------------------------------------------------------------------*/
    int TLSearchWatchdog::DefaultEvents() const

/*  Returns the set of search events that the monitor is interested in.
---------------------------------------------------------------------------*/
{
    return TLSearcher::sePreProcess | TLSearcher::seEnter;
}

/*-------------------------------------------------------------------------*/
    void TLSearchWatchdog::OnSearchEvent(
    	TLSearcher *	aSearcher,
    	const Event &	aEvent)

/*  Call-back for events handled by this monitor. It updates the node
    counter and terminates the searcher if expired.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aSearcher);

    switch (aEvent.mCode)
    {
	case TLSearcher::sePreProcess:
	{
	    // The preprocess event is used to reset the node count

	    mProblemCount = 0;
	    break;
	}

	case TLSearcher::seEnter:
	    // Whenever a problem is processed, it is counted. If the maximum
	    // number is exceeded, the searcher is terminated.

	    if (++mProblemCount > mMaxProblems)
	    {
		TLX_LOG_ENTRY("Watchdog terminates searcher after %ld problems",
			      mProblemCount);
		aSearcher->Terminate();
	    }
	    break;

	// default: all others are ignored
    }
}

/*-------------------------------------------------------------------------*/
    ostream &TLSearchWatchdog::PrintOn(ostream &os) const

/*  Function to print the contents of the monitor on the given stream,
    usually as part of the searcher's ReportStats() processing.
---------------------------------------------------------------------------*/
{
    return os << "Watchdog: " << mProblemCount << " problems counted (max="
    	<< mMaxProblems << ")\n";
}

