/****************************************************************************
    $Id: srchstat.cpp 501.0 1995/03/07 12:26:22 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLSearchStats.

    $Log: srchstat.cpp $
    Revision 501.0  1995/03/07 12:26:22  RON
    Updated for TLX 5.01
    Revision 1.10  1995/02/22 12:43:00  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.9  1995/01/18  10:39:34  ron
    Simplified limit setting of per-depth statistics

    Revision 1.8  1995/01/12  13:41:29  ron
    Adapted to previous Searcher/ProblemRep model

    Revision 1.7  1995/01/08  11:48:09  ron
    Adapted to change in searcher depth type from int32 to int

    Revision 1.6  1995/01/06  15:58:27  ron
    Corrected Revision keyword

    Revision 1.5  1995/01/05  15:29:33  ron
    Naming and formatting changes

    Revision 1.4  1994/11/16  15:43:36  ron
    Added module info; rearranged #include directives

    Revision 1.3  1994/10/13  11:53:30  ron
    Moved class declaration to searcher.h

    Revision 1.2  1994/10/10  16:55:35  ron
    Moved definition of searcher events to TLSearcher

    Revision 1.1  1994/10/07  17:05:35  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <iomanip.h>

#include <tlx\501\solve\searcher.h>

// Template source code

#include <tlx\501\template\array.cpp>
#include <tlx\501\template\stats1.cpp>

/*-------------------------------------------------------------------------*/
    TLSearchStats::TLSearchStats()

/*  Constructor.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    int TLSearchStats::DefaultEvents() const

/*  Returns the set of search events that the monitor is interested in.
---------------------------------------------------------------------------*/
{
    return TLSearcher::sePreProcess | TLSearcher::seInitial |
    	   TLSearcher::seBranch | TLSearcher::seEnter;
}

/*-------------------------------------------------------------------------*/
    void TLSearchStats::OnSearchEvent(
    	TLSearcher *	aSearcher,
    	const Event &	aEvent)

/*  Call-back for events handled by this monitor. It updates search
    statistics.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aSearcher);

    switch (aEvent.mCode)
    {
	case TLSearcher::sePreProcess:
	{
	    // The preprocess event is used to reset the statistics
	    // to resize the level branching array.

	    mDepth.Clear();
	    mBranching.Clear();
	    TLX_ASSERT_PTR(aSearcher->GetProblemRep());
	    mLevelBranch.SetLimits(0, aSearcher->GetProblemRep()->Size());
	    break;
	}
	case TLSearcher::seInitial:
	case TLSearcher::seBranch:
	{
	    // The decomposition events are used to track the branching factor
	    // at each level, and globally.

	    mBranching.Add(aEvent.mUint32Parm);

	    int depth = aSearcher->GetLevel();
	    TLX_ASSERT(depth >= mLevelBranch.Mini());
	    TLX_ASSERT(depth <= mLevelBranch.Maxi());
	    mLevelBranch[depth].Add(aEvent.mUint32Parm);
	    break;
	}
	case TLSearcher::seEnter:
	    // Whenever a problem is processed, its depth is noted to obtain
	    // a measure of the average search depth during the process.

	    mDepth.Add(aSearcher->GetLevel());
	    break;

	// default: all others are ignored
    }
}

/*-------------------------------------------------------------------------*/
    ostream &TLSearchStats::PrintOn(ostream &os) const

/*  Function to print the contents of the monitor on the given stream,
    usually as part of the searcher's ReportStats() processing.
---------------------------------------------------------------------------*/
{
    os << "Depth statistics : " << mDepth << "\n";
    os << "Overall branching: " << mBranching << "\n";
    os << "Per-level branching for " << mLevelBranch.Size() << " levels:\n";

    for (index_t i = mLevelBranch.Mini(); i <= mLevelBranch.Maxi(); i++)
	os << setw(4) << i << " - " << mLevelBranch[i] << "\n";

    return os;
}

