/****************************************************************************
    $Id: srchbrk.cpp 501.0 1995/03/07 12:26:22 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of class TLSearchBreaker.

    $Log: srchbrk.cpp $
    Revision 501.0  1995/03/07 12:26:22  RON
    Updated for TLX 5.01
    Revision 1.6  1995/02/22 12:42:54  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1995/01/10  16:33:52  ron
    Changed wording of message slightly

    Revision 1.4  1995/01/06  15:58:25  ron
    Corrected Revision keyword

    Revision 1.3  1995/01/05  15:28:46  ron
    Naming and formatting changes

    Revision 1.2  1994/11/16  15:43:20  ron
    Added module info; rearranged #include directives

    Revision 1.1  1994/10/13  11:53:06  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <ctype.h>
#include <iostream.h>
#include <signal.h>

#include <tlx\501\log.h>
#include <tlx\501\solve\searcher.h>

#if (defined(__BORLANDC__) && defined(__FLAT__)) || defined(__WATCOMC__)
#define SIGBREAK_DEFINED        1
#endif

/*---------------------------------------------------------------------------
    Global and static data
---------------------------------------------------------------------------*/

bool    TLSearchBreaker::sBreak    = false;
bool    TLSearchBreaker::sNotified = false;
int     TLSearchBreaker::sBCount   = 0;

/*-------------------------------------------------------------------------*/
    TLSearchBreaker::TLSearchBreaker()

/*  Constructor. Installs the Ctrl-Break and Ctrl-C signal handlers.
---------------------------------------------------------------------------*/
{
    if (++sBCount == 1)
    {
      #ifdef SIGBREAK_DEFINED
       #ifdef __WATCOMC__
        signal(SIGBREAK, (__sig_func)BreakHandler);
       #else
        signal(SIGBREAK, BreakHandler);
       #endif 
      #endif
      #ifdef __IBMCPP__
        signal(SIGINT, (_SigFunc)BreakHandler);
      #else
       #ifdef __WATCOMC__
        signal(SIGINT, (__sig_func)BreakHandler);
       #else
        signal(SIGINT, BreakHandler);
       #endif 
      #endif
        sBreak    = false;
        sNotified = false;
    }
}

/*-------------------------------------------------------------------------*/
    TLSearchBreaker::~TLSearchBreaker()

/*  Destructor. Deinstalls the Ctrl-Break and Ctrl-C signal handlers.
---------------------------------------------------------------------------*/
{
    if (--sBCount < 1)
    {
      #ifdef SIGBREAK_DEFINED
        signal(SIGBREAK, SIG_DFL);
      #endif
        signal(SIGINT, SIG_DFL);
    }
}

/*-------------------------------------------------------------------------*/
    int TLSearchBreaker::DefaultEvents() const

/*  Returns the set of search events that the monitor is interested in.
---------------------------------------------------------------------------*/
{
    return TLSearcher::sePreProcess | TLSearcher::seEnter;
}

/*-------------------------------------------------------------------------*/
    void TLSearchBreaker::OnSearchEvent(
        TLSearcher *    aSearcher,
        const Event &   aEvent)

/*  Call-back for events handled by this monitor. It updates the node
    counter and terminates the searcher if expired.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aSearcher);

    switch (aEvent.mCode)
    {
        case TLSearcher::sePreProcess:
        {
            // The preprocess event is used to reset the break indicator

            sBreak    = false;
            sNotified = false;
            break;
        }

        case TLSearcher::seEnter:
            // Whenever a node is entered, the break indicator is checked.
            // If set, the searcher is terminated.

            if (sBreak && !sNotified)
            {
                cerr << "\nCtrl-Break: Do you want to terminate "
                        "the search process (y/n)? ";
                char rsp;
                cin >> rsp;

                if (toupper(rsp) == 'Y')
                    sNotified = true;
                else
                    sBreak = false;
            }
            if (sBreak)
            {
                TLX_LOG_ENTRY("Ctrl-Break terminates searcher");
                aSearcher->Terminate();
            }
            break;

        // default: all others are ignored
    }
}

/*-------------------------------------------------------------------------*/
    ostream &TLSearchBreaker::PrintOn(ostream &os) const

/*  Function to print the contents of the monitor on the given stream,
    usually as part of the searcher's ReportStats() processing.
---------------------------------------------------------------------------*/
{
    return os << "Breaker: flag=" << sBreak << "\n";
}

/*-------------------------------------------------------------------------*/
    void __cdecl TLSearchBreaker::BreakHandler(int)

/*  Signal handler for search breaker.
---------------------------------------------------------------------------*/
{
    sBreak = true;
#ifdef SIGBREAK_DEFINED
  #ifdef __WATCOMC__
    signal(SIGBREAK, (__sig_func)BreakHandler);
  #else
    signal(SIGBREAK, BreakHandler);
  #endif 
#endif
#ifdef __IBMCPP__
    signal(SIGINT, (_SigFunc)BreakHandler);
#else
  #ifdef __WATCOMC__
    signal(SIGINT, (__sig_func)BreakHandler);
  #else
    signal(SIGINT, BreakHandler);
  #endif 
#endif
}
