/****************************************************************************
    $Id: slink.cpp 501.0 1995/03/07 12:26:22 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLSLink. This class represents an element in the
    various list structures. Its member functions are geared towards linear
    list implementations, so a circular list implementation must take some
    extra care.

    $Log: slink.cpp $
    Revision 501.0  1995/03/07 12:26:22  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:24  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:58:20  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:43:05  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/09/28  14:46:25  ron
    Removed Macintosh-style #include references

    Revision 1.4  1994/09/28  14:21:48  ron
    Changed an incorrect assumption which caused an assertion failure
    in Append()

    Revision 1.3  1994/09/27  20:23:01  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:47:32  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:13  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\slists.h>		// Class declaration

/*-------------------------------------------------------------------------*/
    TLSLink::TLSLink()

/*  Default constructor. Sets link field to 0.
---------------------------------------------------------------------------*/
: mNext(0)
{
}

/*-------------------------------------------------------------------------*/
    TLSLink::TLSLink(const TLSLink &)

/*  Copy constructor. Does not copy the link field, but sets it to 0.
---------------------------------------------------------------------------*/
: mNext(0)
{
}

/*-------------------------------------------------------------------------*/
    TLSLink::~TLSLink()

/*  Destructor. In the debugging version, it checks that it is unlinked.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_NULL(mNext);
}

/*-------------------------------------------------------------------------*/
    void TLSLink::Append(TLSLink *aLink)

/*  Inserts 'aLink' after the current TLSLink. The current TLSLink must not
    be part of a chain. It is an error to pass a 0 pointer.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aLink);
    TLX_ASSERT_NULL(mNext);

    mNext = aLink;
}

/*-------------------------------------------------------------------------*/
    TLSLink &TLSLink::operator =(const TLSLink &)

/*  Overloading of the assignment operator. Does not copy the link fields.
---------------------------------------------------------------------------*/
{
    return *this;
}

/*-------------------------------------------------------------------------*/
    void TLSLink::Unlink()

/*  Removes the current TLSLink from the list of which it is part.
---------------------------------------------------------------------------*/
{
    mNext = 0;
}

