ORIGIN		= Symantec C++
ORIGIN_VER	= Version 7.20
VERSION		= DEBUG

!IFDEF SUB_DEBUG
DEBUG		= $(SUB_DEBUG)
NDEBUG		= !$(SUB_DEBUG)
!ELSE
DEBUG		= 1
NDEBUG		= 0
!ENDIF

PROJ		= TlxLib
APPTYPE		= WIN32 LIB
PROJTYPE	= LIB

CC		= SC
CPP		= SPP
MAKE		= SMAKE
RC		= RCC
HC		= HC31
ASM		= SC
DISASM		= OBJ2ASM
LNK		= LINK
DLLS		= 

HEADERS		= ..\..\..\..\..\SC7\INCLUDE\typeinfo.h ..\..\..\..\..\SC7\INCLUDE\win32\objidl.h ..\..\..\..\..\SC7\INCLUDE\win32\unknwn.h  \
		..\..\..\..\..\SC7\INCLUDE\win32\wtypes.h ..\..\..\..\..\SC7\INCLUDE\win32\ole2.h ..\..\..\..\..\SC7\INCLUDE\win32\windows.h ..\..\..\..\..\SC7\INCLUDE\win32\rpcndr.h  \
		..\..\..\..\..\SC7\INCLUDE\win32\rpc.h ..\..\..\..\..\SC7\INCLUDE\win32\poppack.h ..\..\..\..\..\SC7\INCLUDE\win32\pshpack1.h 

DEFFILE		= TlxLib.DEF

!IF $(DEBUG)
OUTPUTDIR	= Debug
!IF EXIST (Debug)
CREATEOUTPUTDIR	=
!ELSE
CREATEOUTPUTDIR	= if not exist $(OUTPUTDIR)\*.* md $(OUTPUTDIR)
!ENDIF
TARGETDIR	= Debug
!IF EXIST (Debug)
CREATETARGETDIR	=
!ELSE
CREATETARGETDIR	= if not exist $(TARGETDIR)\*.* md $(TARGETDIR)
!ENDIF

LIBS		= 

CFLAGS		=  -Ae -Ar -Aa -r -mn -C -D_WINDOWS -S -3 -a8 -c -g -gd 
LFLAGS		=  /CO /NOI /DE /XN /A:512
DEFINES		= -D_TLXBUILD -D_TLXDBG
!ELSE
OUTPUTDIR	= Release
!IF EXIST (Release)
CREATEOUTPUTDIR	=
!ELSE
CREATEOUTPUTDIR	= if not exist $(OUTPUTDIR)\*.* md $(OUTPUTDIR)
!ENDIF
TARGETDIR	= Release
!IF EXIST (Release)
CREATETARGETDIR	=
!ELSE
CREATETARGETDIR	= if not exist $(TARGETDIR)\*.* md $(TARGETDIR)
!ENDIF

LIBS		= 

CFLAGS		=  -Ae -Ar -Aa -r -mn -o+time -D_WINDOWS -3 -a8 -c 
LFLAGS		=  /NOI /DE /E /PACKF /XN /A:512
DEFINES		= -D_TLXBUILD
!ENDIF

HFLAGS		= $(CFLAGS) 
MFLAGS		= MASTERPROJ=$(PROJ) 
LIBFLAGS	=  /C /N /P:128 
RESFLAGS	=  -32 
DEBUGGERFLAGS	=  
AFLAGS		= $(CFLAGS) 
HELPFLAGS	= 

MODEL		= N

PAR		= PROJS BATS OBJS

RCDEFINES	= 

INCLUDES	= -Id:\dev

INCLUDEDOBJS	= 

OBJS		=  $(OUTPUTDIR)\ASSERTS.OBJ  $(OUTPUTDIR)\BATCHAPP.OBJ  $(OUTPUTDIR)\BBINFO.OBJ  \
		 $(OUTPUTDIR)\BBSEARCH.OBJ  $(OUTPUTDIR)\BBSRCHDF.OBJ  $(OUTPUTDIR)\BBSTATS.OBJ  $(OUTPUTDIR)\BINCON.OBJ  \
		 $(OUTPUTDIR)\BITVECT.OBJ  $(OUTPUTDIR)\BTSEARCH.OBJ  $(OUTPUTDIR)\BTSRCHRC.OBJ  $(OUTPUTDIR)\CDCHECK.OBJ  \
		 $(OUTPUTDIR)\CONSTRAI.OBJ  $(OUTPUTDIR)\CSPMONIT.OBJ  $(OUTPUTDIR)\CSPREP.OBJ  $(OUTPUTDIR)\CSPTMPL1.OBJ  \
		 $(OUTPUTDIR)\CSPTMPL2.OBJ  $(OUTPUTDIR)\CSSUBPRB.OBJ  $(OUTPUTDIR)\DISPOSBL.OBJ  $(OUTPUTDIR)\DLBASE.OBJ  \
		 $(OUTPUTDIR)\DLCBASE.OBJ  $(OUTPUTDIR)\DLINK.OBJ  $(OUTPUTDIR)\DLQBASE.OBJ  $(OUTPUTDIR)\DLSTBASE.OBJ  \
		 $(OUTPUTDIR)\DOMAIN.OBJ  $(OUTPUTDIR)\DOMELEM.OBJ  $(OUTPUTDIR)\DOMMONIT.OBJ  $(OUTPUTDIR)\EXCEPT.OBJ  \
		 $(OUTPUTDIR)\GETOPT.OBJ  $(OUTPUTDIR)\INTSET.OBJ  $(OUTPUTDIR)\ITER.OBJ  $(OUTPUTDIR)\LOG.OBJ  \
		 $(OUTPUTDIR)\MODINFO.OBJ  $(OUTPUTDIR)\NETBIOS.OBJ  $(OUTPUTDIR)\NODECON.OBJ  $(OUTPUTDIR)\PROBLINF.OBJ  \
		 $(OUTPUTDIR)\PROBLIST.OBJ  $(OUTPUTDIR)\PROBLREP.OBJ  $(OUTPUTDIR)\PROFILE.OBJ  $(OUTPUTDIR)\PROPAC3.OBJ  \
		 $(OUTPUTDIR)\PROPAGAT.OBJ  $(OUTPUTDIR)\PROPFC.OBJ  $(OUTPUTDIR)\REF.OBJ  $(OUTPUTDIR)\REFPTR.OBJ  \
		 $(OUTPUTDIR)\SEARCHER.OBJ  $(OUTPUTDIR)\SLBASE.OBJ  $(OUTPUTDIR)\SLCBASE.OBJ  $(OUTPUTDIR)\SLINK.OBJ  \
		 $(OUTPUTDIR)\SLQBASE.OBJ  $(OUTPUTDIR)\SLSTBASE.OBJ  $(OUTPUTDIR)\SOLUTION.OBJ  $(OUTPUTDIR)\SRCHBRK.OBJ  \
		 $(OUTPUTDIR)\SRCHMON.OBJ  $(OUTPUTDIR)\SRCHSTAT.OBJ  $(OUTPUTDIR)\SRCHWDOG.OBJ  $(OUTPUTDIR)\STRDUPNW.OBJ  \
		 $(OUTPUTDIR)\STRINGS.OBJ  $(OUTPUTDIR)\SUBPROBL.OBJ  $(OUTPUTDIR)\SUPLIST.OBJ  $(OUTPUTDIR)\SWAPS.OBJ  \
		 $(OUTPUTDIR)\TIMESTMP.OBJ  $(OUTPUTDIR)\TLX.OBJ  $(OUTPUTDIR)\TRACE.OBJ  $(OUTPUTDIR)\VARIABLE.OBJ  \
		 $(OUTPUTDIR)\VARSELCT.OBJ  $(OUTPUTDIR)\VPARRAY.OBJ  $(OUTPUTDIR)\VPQUEUE.OBJ  $(OUTPUTDIR)\VPSEQ.OBJ  \
		 $(OUTPUTDIR)\VPSET.OBJ  $(OUTPUTDIR)\VPSTACK.OBJ  $(OUTPUTDIR)\VPVECTOR.OBJ  $(OUTPUTDIR)\VVLINK.OBJ  \
		 $(OUTPUTDIR)\XALLOC.OBJ  $(OUTPUTDIR)\XASSERT.OBJ  $(OUTPUTDIR)\XEMPTY.OBJ  $(OUTPUTDIR)\XFULL.OBJ  \
		 $(OUTPUTDIR)\XINDEX.OBJ  $(OUTPUTDIR)\XIOS.OBJ  $(OUTPUTDIR)\XLOCUS.OBJ  $(OUTPUTDIR)\XNOTFND.OBJ  \
		 $(OUTPUTDIR)\XNULLPTR.OBJ  $(OUTPUTDIR)\XRESIZE.OBJ  $(OUTPUTDIR)\XSTDIO.OBJ 

RCFILES		= 

RESFILES	= 

SYMS		= 

HELPFILES	= 

BATS		= 

.SUFFIXES: .C .CP .CPP .CXX .CC .H .HPP .HXX .COM .EXE .DLL .LIB .RTF .DLG .ASM .RES .RC .OBJ 

.C.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.c

.CPP.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cpp

.CXX.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cxx

.CC.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cc

.CP.OBJ:
	$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.cp

.H.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$(*B).sym $*.h

.HPP.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$(*B).sym $*.hpp

.HXX.SYM:
	$(CC) $(HFLAGS) $(DEFINES) $(INCLUDES) -HF -o$(*B).sym $*.hxx

.C.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES)   $*.c   -o$*.lst

.CPP.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES) $*.cpp -o$*.lst

.CXX.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES) $*.cxx -o$*.lst

.CP.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES)  $*.cp  -o$*.lst

.CC.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES)  $*.cc  -o$*.lst

.ASM.EXP:
	$(CPP) $(CFLAGS) $(DEFINES) $(INCLUDES) $*.asm -o$*.lst

.OBJ.COD:
	$(DISASM) $*.OBJ -c

.OBJ.EXE:
	$(LNK) $(LFLAGS) @$(PROJ).LNK

.RTF.HLP:
	$(HC) $(HELPFLAGS) $*.HPJ

.ASM.OBJ:
	$(ASM) $(AFLAGS) $(DEFINES) $(INCLUDES) -o$*.obj $*.asm

.RC.RES: 
	$(RC) $(RCDEFINES) $(RESFLAGS) $(INCLUDES) $*.rc -o$*.res

.DLG.RES:
	echo ^#include "windows.h" >$$$*.rc
	echo ^IF EXIST "$*.h" >>$$$*.rc
	echo ^#include "$*.h" >>$$$*.rc
	echo ^#include "$*.dlg" >>$$$*.rc
	$(RC) $(RCDEFINES) $(RESFLAGS) $(INCLUDES) $$$*.rc
	-del $*.res
	-ren $$$*.res $*.res



all:	createdir $(PRECOMPILE) $(SYMS) $(OBJS) $(INCLUDEDOBJS) $(POSTCOMPILE) $(TARGETDIR)\$(PROJ).$(PROJTYPE) $(POSTLINK) _done

createdir:
	$(CREATEOUTPUTDIR)
	$(CREATETARGETDIR)

$(TARGETDIR)\$(PROJ).$(PROJTYPE): $(OBJS) $(INCLUDEDOBJS) $(RCFILES) $(RESFILES) $(HELPFILES) 
			-del $(TARGETDIR)\$(PROJ).$(PROJTYPE)
		LIB $(TARGETDIR)\$$SCW$$.$(PROJTYPE) $(LIBFLAGS)\
				@<<
 +$(OUTPUTDIR)\ASSERTS.OBJ +$(OUTPUTDIR)\BATCHAPP.OBJ +$(OUTPUTDIR)\BBINFO.OBJ &
		 +$(OUTPUTDIR)\BBSEARCH.OBJ +$(OUTPUTDIR)\BBSRCHDF.OBJ +$(OUTPUTDIR)\BBSTATS.OBJ +$(OUTPUTDIR)\BINCON.OBJ &
		 +$(OUTPUTDIR)\BITVECT.OBJ +$(OUTPUTDIR)\BTSEARCH.OBJ +$(OUTPUTDIR)\BTSRCHRC.OBJ +$(OUTPUTDIR)\CDCHECK.OBJ &
		 +$(OUTPUTDIR)\CONSTRAI.OBJ +$(OUTPUTDIR)\CSPMONIT.OBJ +$(OUTPUTDIR)\CSPREP.OBJ +$(OUTPUTDIR)\CSPTMPL1.OBJ &
		 +$(OUTPUTDIR)\CSPTMPL2.OBJ +$(OUTPUTDIR)\CSSUBPRB.OBJ +$(OUTPUTDIR)\DISPOSBL.OBJ +$(OUTPUTDIR)\DLBASE.OBJ &
		 +$(OUTPUTDIR)\DLCBASE.OBJ +$(OUTPUTDIR)\DLINK.OBJ +$(OUTPUTDIR)\DLQBASE.OBJ +$(OUTPUTDIR)\DLSTBASE.OBJ &
		 +$(OUTPUTDIR)\DOMAIN.OBJ +$(OUTPUTDIR)\DOMELEM.OBJ +$(OUTPUTDIR)\DOMMONIT.OBJ +$(OUTPUTDIR)\EXCEPT.OBJ &
		 +$(OUTPUTDIR)\GETOPT.OBJ +$(OUTPUTDIR)\INTSET.OBJ +$(OUTPUTDIR)\ITER.OBJ +$(OUTPUTDIR)\LOG.OBJ &
		 +$(OUTPUTDIR)\MODINFO.OBJ +$(OUTPUTDIR)\NETBIOS.OBJ +$(OUTPUTDIR)\NODECON.OBJ +$(OUTPUTDIR)\PROBLINF.OBJ &
		 +$(OUTPUTDIR)\PROBLIST.OBJ +$(OUTPUTDIR)\PROBLREP.OBJ +$(OUTPUTDIR)\PROFILE.OBJ +$(OUTPUTDIR)\PROPAC3.OBJ &
		 +$(OUTPUTDIR)\PROPAGAT.OBJ +$(OUTPUTDIR)\PROPFC.OBJ +$(OUTPUTDIR)\REF.OBJ +$(OUTPUTDIR)\REFPTR.OBJ &
		 +$(OUTPUTDIR)\SEARCHER.OBJ +$(OUTPUTDIR)\SLBASE.OBJ +$(OUTPUTDIR)\SLCBASE.OBJ +$(OUTPUTDIR)\SLINK.OBJ &
		 +$(OUTPUTDIR)\SLQBASE.OBJ +$(OUTPUTDIR)\SLSTBASE.OBJ +$(OUTPUTDIR)\SOLUTION.OBJ +$(OUTPUTDIR)\SRCHBRK.OBJ &
		 +$(OUTPUTDIR)\SRCHMON.OBJ +$(OUTPUTDIR)\SRCHSTAT.OBJ +$(OUTPUTDIR)\SRCHWDOG.OBJ +$(OUTPUTDIR)\STRDUPNW.OBJ &
		 +$(OUTPUTDIR)\STRINGS.OBJ +$(OUTPUTDIR)\SUBPROBL.OBJ +$(OUTPUTDIR)\SUPLIST.OBJ +$(OUTPUTDIR)\SWAPS.OBJ &
		 +$(OUTPUTDIR)\TIMESTMP.OBJ +$(OUTPUTDIR)\TLX.OBJ +$(OUTPUTDIR)\TRACE.OBJ +$(OUTPUTDIR)\VARIABLE.OBJ &
		 +$(OUTPUTDIR)\VARSELCT.OBJ +$(OUTPUTDIR)\VPARRAY.OBJ +$(OUTPUTDIR)\VPQUEUE.OBJ +$(OUTPUTDIR)\VPSEQ.OBJ &
		 +$(OUTPUTDIR)\VPSET.OBJ +$(OUTPUTDIR)\VPSTACK.OBJ +$(OUTPUTDIR)\VPVECTOR.OBJ +$(OUTPUTDIR)\VVLINK.OBJ &
		 +$(OUTPUTDIR)\XALLOC.OBJ +$(OUTPUTDIR)\XASSERT.OBJ +$(OUTPUTDIR)\XEMPTY.OBJ +$(OUTPUTDIR)\XFULL.OBJ &
		 +$(OUTPUTDIR)\XINDEX.OBJ +$(OUTPUTDIR)\XIOS.OBJ +$(OUTPUTDIR)\XLOCUS.OBJ +$(OUTPUTDIR)\XNOTFND.OBJ &
		 +$(OUTPUTDIR)\XNULLPTR.OBJ +$(OUTPUTDIR)\XRESIZE.OBJ +$(OUTPUTDIR)\XSTDIO.OBJ
<<
			-ren $(TARGETDIR)\$$SCW$$.$(PROJTYPE) $(PROJ).$(PROJTYPE)
			-echo $(TARGETDIR)\$(PROJ).$(PROJTYPE) built

_done:
		-echo $(PROJ).$(PROJTYPE) done

buildall:	clean	all


clean:
		-del $(TARGETDIR)\$$SCW$$.$(PROJTYPE)
		-del $(TARGETDIR)\$(PROJ).CLE
		-del $(OUTPUTDIR)\SCPH.SYM
		-del TlxLib.dpd
		-del $(OBJS)

cleanres:

res:		cleanres $(RCFILES) all


link:
		LIB $(TARGETDIR)\$$SCW$$.$(PROJTYPE) $(LIBFLAGS)\
				@<<
 +$(OUTPUTDIR)\ASSERTS.OBJ +$(OUTPUTDIR)\BATCHAPP.OBJ +$(OUTPUTDIR)\BBINFO.OBJ &
		 +$(OUTPUTDIR)\BBSEARCH.OBJ +$(OUTPUTDIR)\BBSRCHDF.OBJ +$(OUTPUTDIR)\BBSTATS.OBJ +$(OUTPUTDIR)\BINCON.OBJ &
		 +$(OUTPUTDIR)\BITVECT.OBJ +$(OUTPUTDIR)\BTSEARCH.OBJ +$(OUTPUTDIR)\BTSRCHRC.OBJ +$(OUTPUTDIR)\CDCHECK.OBJ &
		 +$(OUTPUTDIR)\CONSTRAI.OBJ +$(OUTPUTDIR)\CSPMONIT.OBJ +$(OUTPUTDIR)\CSPREP.OBJ +$(OUTPUTDIR)\CSPTMPL1.OBJ &
		 +$(OUTPUTDIR)\CSPTMPL2.OBJ +$(OUTPUTDIR)\CSSUBPRB.OBJ +$(OUTPUTDIR)\DISPOSBL.OBJ +$(OUTPUTDIR)\DLBASE.OBJ &
		 +$(OUTPUTDIR)\DLCBASE.OBJ +$(OUTPUTDIR)\DLINK.OBJ +$(OUTPUTDIR)\DLQBASE.OBJ +$(OUTPUTDIR)\DLSTBASE.OBJ &
		 +$(OUTPUTDIR)\DOMAIN.OBJ +$(OUTPUTDIR)\DOMELEM.OBJ +$(OUTPUTDIR)\DOMMONIT.OBJ +$(OUTPUTDIR)\EXCEPT.OBJ &
		 +$(OUTPUTDIR)\GETOPT.OBJ +$(OUTPUTDIR)\INTSET.OBJ +$(OUTPUTDIR)\ITER.OBJ +$(OUTPUTDIR)\LOG.OBJ &
		 +$(OUTPUTDIR)\MODINFO.OBJ +$(OUTPUTDIR)\NETBIOS.OBJ +$(OUTPUTDIR)\NODECON.OBJ +$(OUTPUTDIR)\PROBLINF.OBJ &
		 +$(OUTPUTDIR)\PROBLIST.OBJ +$(OUTPUTDIR)\PROBLREP.OBJ +$(OUTPUTDIR)\PROFILE.OBJ +$(OUTPUTDIR)\PROPAC3.OBJ &
		 +$(OUTPUTDIR)\PROPAGAT.OBJ +$(OUTPUTDIR)\PROPFC.OBJ +$(OUTPUTDIR)\REF.OBJ +$(OUTPUTDIR)\REFPTR.OBJ &
		 +$(OUTPUTDIR)\SEARCHER.OBJ +$(OUTPUTDIR)\SLBASE.OBJ +$(OUTPUTDIR)\SLCBASE.OBJ +$(OUTPUTDIR)\SLINK.OBJ &
		 +$(OUTPUTDIR)\SLQBASE.OBJ +$(OUTPUTDIR)\SLSTBASE.OBJ +$(OUTPUTDIR)\SOLUTION.OBJ +$(OUTPUTDIR)\SRCHBRK.OBJ &
		 +$(OUTPUTDIR)\SRCHMON.OBJ +$(OUTPUTDIR)\SRCHSTAT.OBJ +$(OUTPUTDIR)\SRCHWDOG.OBJ +$(OUTPUTDIR)\STRDUPNW.OBJ &
		 +$(OUTPUTDIR)\STRINGS.OBJ +$(OUTPUTDIR)\SUBPROBL.OBJ +$(OUTPUTDIR)\SUPLIST.OBJ +$(OUTPUTDIR)\SWAPS.OBJ &
		 +$(OUTPUTDIR)\TIMESTMP.OBJ +$(OUTPUTDIR)\TLX.OBJ +$(OUTPUTDIR)\TRACE.OBJ +$(OUTPUTDIR)\VARIABLE.OBJ &
		 +$(OUTPUTDIR)\VARSELCT.OBJ +$(OUTPUTDIR)\VPARRAY.OBJ +$(OUTPUTDIR)\VPQUEUE.OBJ +$(OUTPUTDIR)\VPSEQ.OBJ &
		 +$(OUTPUTDIR)\VPSET.OBJ +$(OUTPUTDIR)\VPSTACK.OBJ +$(OUTPUTDIR)\VPVECTOR.OBJ +$(OUTPUTDIR)\VVLINK.OBJ &
		 +$(OUTPUTDIR)\XALLOC.OBJ +$(OUTPUTDIR)\XASSERT.OBJ +$(OUTPUTDIR)\XEMPTY.OBJ +$(OUTPUTDIR)\XFULL.OBJ &
		 +$(OUTPUTDIR)\XINDEX.OBJ +$(OUTPUTDIR)\XIOS.OBJ +$(OUTPUTDIR)\XLOCUS.OBJ +$(OUTPUTDIR)\XNOTFND.OBJ &
		 +$(OUTPUTDIR)\XNULLPTR.OBJ +$(OUTPUTDIR)\XRESIZE.OBJ +$(OUTPUTDIR)\XSTDIO.OBJ
<<
		-del $(TARGETDIR)\$(PROJ).$(PROJTYPE)
		-ren $(TARGETDIR)\$$SCW$$.$(PROJTYPE) $(PROJ).$(PROJTYPE)




!IF EXIST (TlxLib.dpd)
!INCLUDE TlxLib.dpd
!ENDIF



$(OUTPUTDIR)\ASSERTS.OBJ:	..\ASSERTS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\ASSERTS.obj ..\ASSERTS.CPP



$(OUTPUTDIR)\BATCHAPP.OBJ:	..\BATCHAPP.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BATCHAPP.obj ..\BATCHAPP.CPP



$(OUTPUTDIR)\BBINFO.OBJ:	..\BBINFO.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BBINFO.obj ..\BBINFO.CPP



$(OUTPUTDIR)\BBSEARCH.OBJ:	..\BBSEARCH.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BBSEARCH.obj ..\BBSEARCH.CPP



$(OUTPUTDIR)\BBSRCHDF.OBJ:	..\BBSRCHDF.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BBSRCHDF.obj ..\BBSRCHDF.CPP



$(OUTPUTDIR)\BBSTATS.OBJ:	..\BBSTATS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BBSTATS.obj ..\BBSTATS.CPP



$(OUTPUTDIR)\BINCON.OBJ:	..\BINCON.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BINCON.obj ..\BINCON.CPP



$(OUTPUTDIR)\BITVECT.OBJ:	..\BITVECT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BITVECT.obj ..\BITVECT.CPP



$(OUTPUTDIR)\BTSEARCH.OBJ:	..\BTSEARCH.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BTSEARCH.obj ..\BTSEARCH.CPP



$(OUTPUTDIR)\BTSRCHRC.OBJ:	..\BTSRCHRC.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\BTSRCHRC.obj ..\BTSRCHRC.CPP



$(OUTPUTDIR)\CDCHECK.OBJ:	..\CDCHECK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CDCHECK.obj ..\CDCHECK.CPP



$(OUTPUTDIR)\CONSTRAI.OBJ:	..\CONSTRAI.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CONSTRAI.obj ..\CONSTRAI.CPP



$(OUTPUTDIR)\CSPMONIT.OBJ:	..\CSPMONIT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CSPMONIT.obj ..\CSPMONIT.CPP



$(OUTPUTDIR)\CSPREP.OBJ:	..\CSPREP.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CSPREP.obj ..\CSPREP.CPP



$(OUTPUTDIR)\CSPTMPL1.OBJ:	..\CSPTMPL1.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CSPTMPL1.obj ..\CSPTMPL1.CPP



$(OUTPUTDIR)\CSPTMPL2.OBJ:	..\CSPTMPL2.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CSPTMPL2.obj ..\CSPTMPL2.CPP



$(OUTPUTDIR)\CSSUBPRB.OBJ:	..\CSSUBPRB.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\CSSUBPRB.obj ..\CSSUBPRB.CPP



$(OUTPUTDIR)\DISPOSBL.OBJ:	..\DISPOSBL.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DISPOSBL.obj ..\DISPOSBL.CPP



$(OUTPUTDIR)\DLBASE.OBJ:	..\DLBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DLBASE.obj ..\DLBASE.CPP



$(OUTPUTDIR)\DLCBASE.OBJ:	..\DLCBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DLCBASE.obj ..\DLCBASE.CPP



$(OUTPUTDIR)\DLINK.OBJ:	..\DLINK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DLINK.obj ..\DLINK.CPP



$(OUTPUTDIR)\DLQBASE.OBJ:	..\DLQBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DLQBASE.obj ..\DLQBASE.CPP



$(OUTPUTDIR)\DLSTBASE.OBJ:	..\DLSTBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DLSTBASE.obj ..\DLSTBASE.CPP



$(OUTPUTDIR)\DOMAIN.OBJ:	..\DOMAIN.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DOMAIN.obj ..\DOMAIN.CPP



$(OUTPUTDIR)\DOMELEM.OBJ:	..\DOMELEM.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DOMELEM.obj ..\DOMELEM.CPP



$(OUTPUTDIR)\DOMMONIT.OBJ:	..\DOMMONIT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\DOMMONIT.obj ..\DOMMONIT.CPP



$(OUTPUTDIR)\EXCEPT.OBJ:	..\EXCEPT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\EXCEPT.obj ..\EXCEPT.CPP



$(OUTPUTDIR)\GETOPT.OBJ:	..\GETOPT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\GETOPT.obj ..\GETOPT.CPP



$(OUTPUTDIR)\INTSET.OBJ:	..\INTSET.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\INTSET.obj ..\INTSET.CPP



$(OUTPUTDIR)\ITER.OBJ:	..\ITER.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\ITER.obj ..\ITER.CPP



$(OUTPUTDIR)\LOG.OBJ:	..\LOG.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\LOG.obj ..\LOG.CPP



$(OUTPUTDIR)\MODINFO.OBJ:	..\MODINFO.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\MODINFO.obj ..\MODINFO.CPP



$(OUTPUTDIR)\NETBIOS.OBJ:	..\NETBIOS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\NETBIOS.obj ..\NETBIOS.CPP



$(OUTPUTDIR)\NODECON.OBJ:	..\NODECON.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\NODECON.obj ..\NODECON.CPP



$(OUTPUTDIR)\PROBLINF.OBJ:	..\PROBLINF.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROBLINF.obj ..\PROBLINF.CPP



$(OUTPUTDIR)\PROBLIST.OBJ:	..\PROBLIST.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROBLIST.obj ..\PROBLIST.CPP



$(OUTPUTDIR)\PROBLREP.OBJ:	..\PROBLREP.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROBLREP.obj ..\PROBLREP.CPP



$(OUTPUTDIR)\PROFILE.OBJ:	..\PROFILE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROFILE.obj ..\PROFILE.CPP



$(OUTPUTDIR)\PROPAC3.OBJ:	..\PROPAC3.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROPAC3.obj ..\PROPAC3.CPP



$(OUTPUTDIR)\PROPAGAT.OBJ:	..\PROPAGAT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROPAGAT.obj ..\PROPAGAT.CPP



$(OUTPUTDIR)\PROPFC.OBJ:	..\PROPFC.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\PROPFC.obj ..\PROPFC.CPP



$(OUTPUTDIR)\REF.OBJ:	..\REF.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\REF.obj ..\REF.CPP



$(OUTPUTDIR)\REFPTR.OBJ:	..\REFPTR.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\REFPTR.obj ..\REFPTR.CPP



$(OUTPUTDIR)\SEARCHER.OBJ:	..\SEARCHER.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SEARCHER.obj ..\SEARCHER.CPP



$(OUTPUTDIR)\SLBASE.OBJ:	..\SLBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SLBASE.obj ..\SLBASE.CPP



$(OUTPUTDIR)\SLCBASE.OBJ:	..\SLCBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SLCBASE.obj ..\SLCBASE.CPP



$(OUTPUTDIR)\SLINK.OBJ:	..\SLINK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SLINK.obj ..\SLINK.CPP



$(OUTPUTDIR)\SLQBASE.OBJ:	..\SLQBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SLQBASE.obj ..\SLQBASE.CPP



$(OUTPUTDIR)\SLSTBASE.OBJ:	..\SLSTBASE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SLSTBASE.obj ..\SLSTBASE.CPP



$(OUTPUTDIR)\SOLUTION.OBJ:	..\SOLUTION.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SOLUTION.obj ..\SOLUTION.CPP



$(OUTPUTDIR)\SRCHBRK.OBJ:	..\SRCHBRK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SRCHBRK.obj ..\SRCHBRK.CPP



$(OUTPUTDIR)\SRCHMON.OBJ:	..\SRCHMON.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SRCHMON.obj ..\SRCHMON.CPP



$(OUTPUTDIR)\SRCHSTAT.OBJ:	..\SRCHSTAT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SRCHSTAT.obj ..\SRCHSTAT.CPP



$(OUTPUTDIR)\SRCHWDOG.OBJ:	..\SRCHWDOG.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SRCHWDOG.obj ..\SRCHWDOG.CPP



$(OUTPUTDIR)\STRDUPNW.OBJ:	..\STRDUPNW.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\STRDUPNW.obj ..\STRDUPNW.CPP



$(OUTPUTDIR)\STRINGS.OBJ:	..\STRINGS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\STRINGS.obj ..\STRINGS.CPP



$(OUTPUTDIR)\SUBPROBL.OBJ:	..\SUBPROBL.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SUBPROBL.obj ..\SUBPROBL.CPP



$(OUTPUTDIR)\SUPLIST.OBJ:	..\SUPLIST.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SUPLIST.obj ..\SUPLIST.CPP



$(OUTPUTDIR)\SWAPS.OBJ:	..\SWAPS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\SWAPS.obj ..\SWAPS.CPP



$(OUTPUTDIR)\TIMESTMP.OBJ:	..\TIMESTMP.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\TIMESTMP.obj ..\TIMESTMP.CPP



$(OUTPUTDIR)\TLX.OBJ:	..\TLX.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\TLX.obj ..\TLX.CPP



$(OUTPUTDIR)\TRACE.OBJ:	..\TRACE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\TRACE.obj ..\TRACE.CPP



$(OUTPUTDIR)\VARIABLE.OBJ:	..\VARIABLE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VARIABLE.obj ..\VARIABLE.CPP



$(OUTPUTDIR)\VARSELCT.OBJ:	..\VARSELCT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VARSELCT.obj ..\VARSELCT.CPP



$(OUTPUTDIR)\VPARRAY.OBJ:	..\VPARRAY.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPARRAY.obj ..\VPARRAY.CPP



$(OUTPUTDIR)\VPQUEUE.OBJ:	..\VPQUEUE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPQUEUE.obj ..\VPQUEUE.CPP



$(OUTPUTDIR)\VPSEQ.OBJ:	..\VPSEQ.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPSEQ.obj ..\VPSEQ.CPP



$(OUTPUTDIR)\VPSET.OBJ:	..\VPSET.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPSET.obj ..\VPSET.CPP



$(OUTPUTDIR)\VPSTACK.OBJ:	..\VPSTACK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPSTACK.obj ..\VPSTACK.CPP



$(OUTPUTDIR)\VPVECTOR.OBJ:	..\VPVECTOR.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VPVECTOR.obj ..\VPVECTOR.CPP



$(OUTPUTDIR)\VVLINK.OBJ:	..\VVLINK.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\VVLINK.obj ..\VVLINK.CPP



$(OUTPUTDIR)\XALLOC.OBJ:	..\XALLOC.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XALLOC.obj ..\XALLOC.CPP



$(OUTPUTDIR)\XASSERT.OBJ:	..\XASSERT.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XASSERT.obj ..\XASSERT.CPP



$(OUTPUTDIR)\XEMPTY.OBJ:	..\XEMPTY.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XEMPTY.obj ..\XEMPTY.CPP



$(OUTPUTDIR)\XFULL.OBJ:	..\XFULL.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XFULL.obj ..\XFULL.CPP



$(OUTPUTDIR)\XINDEX.OBJ:	..\XINDEX.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XINDEX.obj ..\XINDEX.CPP



$(OUTPUTDIR)\XIOS.OBJ:	..\XIOS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XIOS.obj ..\XIOS.CPP



$(OUTPUTDIR)\XLOCUS.OBJ:	..\XLOCUS.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XLOCUS.obj ..\XLOCUS.CPP



$(OUTPUTDIR)\XNOTFND.OBJ:	..\XNOTFND.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XNOTFND.obj ..\XNOTFND.CPP



$(OUTPUTDIR)\XNULLPTR.OBJ:	..\XNULLPTR.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XNULLPTR.obj ..\XNULLPTR.CPP



$(OUTPUTDIR)\XRESIZE.OBJ:	..\XRESIZE.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XRESIZE.obj ..\XRESIZE.CPP



$(OUTPUTDIR)\XSTDIO.OBJ:	..\XSTDIO.CPP
		$(CC) $(CFLAGS) $(DEFINES) $(INCLUDES) -o$(OUTPUTDIR)\XSTDIO.obj ..\XSTDIO.CPP




