/****************************************************************************
    $Id: ref.cpp 501.0 1995/03/07 12:26:20 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLRefCount.

    $Log: ref.cpp $
    Revision 501.0  1995/03/07 12:26:20  RON
    Updated for TLX 5.01
    Revision 1.10  1995/01/31 16:30:22  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.9  1995/01/06  15:58:13  ron
    Corrected Revision keyword

    Revision 1.8  1995/01/05  15:27:22  ron
    Renamed tracing macro

    Revision 1.7  1994/11/16  15:42:20  ron
    Added module info; rearranged #include directives

    Revision 1.6  1994/09/28  14:20:42  ron
    Removed Macintosh-style #include references

    Revision 1.5  1994/09/27  20:22:50  ron
    Changed path separator from / to \

    Revision 1.4  1994/09/26  15:46:04  ron
    Changed include file references

    Revision 1.3  1994/09/12  14:56:08  ron
    Changed reference count check in destructor to a warning trace

    Revision 1.2  1994/09/06  14:11:53  ron
    Adapted to cange from TLRef to TLRefCount

    Revision 1.1  1994/08/16  18:13:10  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\refcnt.h>		// Class declaration

/*-------------------------------------------------------------------------*/
    TLRefCount::TLRefCount()

/*  Default constructor. Initializes reference count to 0.
---------------------------------------------------------------------------*/
: mRefCnt(0)
{
}

/*-------------------------------------------------------------------------*/
    TLRefCount::TLRefCount(const TLRefCount &)

/*  Copy constructor. Must not copy the reference count, but initialize
    it to 0 instead.
---------------------------------------------------------------------------*/
: mRefCnt(0)
{
}

/*-------------------------------------------------------------------------*/
    TLRefCount::~TLRefCount()

/*  Destructor. Does nothing, but is declared virtual for derivation.
---------------------------------------------------------------------------*/
{
  #ifdef _TLXDBG
    if (mRefCnt > 0)
    	TLX_TRACE_WARN(TLX, ("Destructing RefCount with %d references",
			  mRefCnt));
  #endif
}

/*-------------------------------------------------------------------------*/
    void TLRefCount::Protect()

/*  Protects a TLRefCount instance against deletion through smart pointers.
    They are protected if the reference count is positive. Protection
    is cumulative: it takes as many calls to Unprotect() as there were
    to Protect() in order to remove the protection from a TLRefCount
    instance.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(mRefCnt >= 0);
    mRefCnt++;
}

/*-------------------------------------------------------------------------*/
    void TLRefCount::Unprotect()

/*  Removes a layer of protection from a TLRefCount instance. Protection
    is cumulative: it takes as many calls to Unprotect() as there were
    to Protect() in order to remove the protection from a TLRefCount
    instance.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(mRefCnt >= 1);
    mRefCnt--;
}
