/****************************************************************************
    $Id: propfc.cpp 501.0 1995/03/07 12:26:20 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of the TLPropagatorFC class. This class implements a
    forward-checking constraint propagation algorithm.

    $Log: propfc.cpp $
    Revision 501.0  1995/03/07 12:26:20  RON
    Updated for TLX 5.01
    Revision 1.12  1995/01/31 16:30:22  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.11  1995/01/06  15:58:12  ron
    Corrected Revision keyword

    Revision 1.10  1995/01/05  15:27:10  ron
    Added standard Propagate() functions

    Revision 1.9  1994/11/16  15:42:15  ron
    Added module info; rearranged #include directives

    Revision 1.8  1994/10/10  16:53:47  ron
    Changed to <tlx\solve\csp.h>

    Revision 1.7  1994/10/07  17:03:34  ron
    Changed Unregister...() to Deregister...()

    Revision 1.6  1994/09/28  14:20:28  ron
    Removed Macintosh-style #include references

    Revision 1.5  1994/09/27  20:22:46  ron
    Changed path separator from / to \

    Revision 1.4  1994/09/26  15:45:30  ron
    Adapted to changes in constraint check counting

    Revision 1.3  1994/09/13  10:14:10  ron
    Added a call to reset the failed constraint pointer

    Revision 1.2  1994/09/06  14:07:02  ron
    Adapted implementation of CheckForward() to general changes in CSP

    Revision 1.1  1994/08/16  18:13:08  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <tlx\501\solve\csp.h>

/*-------------------------------------------------------------------------*/
    TLPropagatorFC::TLPropagatorFC()

/*  Constructor. Initializes the propagator.
---------------------------------------------------------------------------*/
: TLPropagator()
{
}

/*-------------------------------------------------------------------------*/
    bool TLPropagatorFC::CheckForward(TLVariable &var)

/*  Performs a forward check that starts with the given variable. Only
    the constraints that originate with this variable are evaluated for
    their effects.

    The function returns nonzero if the system is consistent, else zero.
---------------------------------------------------------------------------*/
{
    SetFailedConstraint(0);
    RegisterPropagator();

    int32 ccnt = TLConstraint::CheckCount();
    bool result = var.PropagateChanges();

    mStats.mCheckCount += TLConstraint::CheckCount() - ccnt;
    DeregisterPropagator();

    return result;
}

/*-------------------------------------------------------------------------*/
    const char *TLPropagatorFC::Description() const

/*  Returns a description of the propagation algorithm.
---------------------------------------------------------------------------*/
{
    return "Forward check";
}

/*-------------------------------------------------------------------------*/
    bool TLPropagatorFC::Propagate(TLVariable *aVar)

/*  Standard propagation interface to propagate from the given variable.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aVar);

    return CheckForward(*aVar);
}

/*-------------------------------------------------------------------------*/
    bool TLPropagatorFC::Propagate(TLPtrIter<TLVariable> &aIter)

/*  Standard propagation interface to propagate from the given list of
    variables.
---------------------------------------------------------------------------*/
{
    for (aIter.Reset(); aIter.Next(); )
    {
	TLX_ASSERT_PTR(aIter.Peek());

	if (!CheckForward(*aIter.Peek()))
	    return false;
    }
    return true;
}
