/****************************************************************************
    $Id: propagat.cpp 501.0 1995/03/07 12:26:20 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of the TLPropagator class. The TLPropagator class
    embodies the various constraint propagation algorithms.

    $Log: propagat.cpp $
    Revision 501.0  1995/03/07 12:26:20  RON
    Updated for TLX 5.01
    Revision 1.11  1995/01/31 16:30:22  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.10  1995/01/06  15:58:10  ron
    Corrected Revision keyword

    Revision 1.9  1994/11/16  15:42:08  ron
    Added module info; rearranged #include directives

    Revision 1.8  1994/10/10  16:53:33  ron
    Changed to <tlx\solve\csp.h>

    Revision 1.7  1994/10/07  17:03:26  ron
    Changed Unregister...() to Deregister...()

    Revision 1.6  1994/09/28  14:20:21  ron
    Removed Macintosh-style #include references

    Revision 1.5  1994/09/27  20:22:45  ron
    Changed path separator from / to \

    Revision 1.4  1994/09/26  15:45:13  ron
    Implemented function to allow nesting of propagators

    Revision 1.3  1994/09/13  10:13:41  ron
    Implemented support to remember the first constraint that failed
    during a constraint propagation.

    Revision 1.2  1994/09/06  14:09:15  ron
    Adapted to changes in CSP framework

    Revision 1.1  1994/08/16  18:13:08  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <tlx\501\solve\csp.h>

/*-------------------------------------------------------------------------*/
    TLPropagator::TLPropagator()

/*  Constructor. Initializes the propagator.
---------------------------------------------------------------------------*/
{
    mPrevProp = 0;
    mFailed   = 0;
    ClearStats();
}

/*-------------------------------------------------------------------------*/
    TLPropagator::~TLPropagator()

/*  Destructor. Deregisters the propagator, in case it was still registered.
---------------------------------------------------------------------------*/
{
    DeregisterPropagator();
}

/*-------------------------------------------------------------------------*/
    void TLPropagator::ClearStats()

/*  Clears the statistics that are kept by the propagator.
---------------------------------------------------------------------------*/
{
    mStats.mCheckCount = 0;
    mStats.mMaxPending = 0;
}

/*-------------------------------------------------------------------------*/
    bool TLPropagator::IsActive() const

/*  Returns true iff the propagator is currently registered with the
    TLVariable class as the active (topmost) propagator.
---------------------------------------------------------------------------*/
{
    return this == TLVariable::sPropagator;
}

/*-------------------------------------------------------------------------*/
    bool TLPropagator::IsRegistered() const

/*  Returns true iff the propagator is currently registered with the
    TLVariable class as a propagator (not necessarily the topmost).
---------------------------------------------------------------------------*/
{
    for (TLPropagator *prop = TLVariable::sPropagator; prop;
	 prop = prop->mPrevProp)
    {
	if (prop == this)
	    return true;
    }
    return false;
}

/*-------------------------------------------------------------------------*/
    void TLPropagator::RegisterPropagator()

/*  Registers the current propagator as the active propagator. It is an
    error to register a propagator while another one is still registered.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!IsRegistered());
    mPrevProp = TLVariable::sPropagator;
    TLVariable::sPropagator = this;
    TLX_ASSERT(IsRegistered());
}

/*-------------------------------------------------------------------------*/
    void TLPropagator::SetFailedConstraint(TLConstraint *aConstraint)

/*  Stores the given constraint pointer (which may be 0) as the constraint
    that failed during constraint propagation.
---------------------------------------------------------------------------*/
{
    mFailed = aConstraint;
}

/*-------------------------------------------------------------------------*/
    void TLPropagator::DeregisterPropagator()

/*  Deregisters the current propagator with the TLVariable class. It is
    an error to all this routine if the current propagator isn't the
    registered one.
---------------------------------------------------------------------------*/
{
    if (this == TLVariable::sPropagator)
    {
	// Topmost; just replace by previous monitor

	TLVariable::sPropagator = mPrevProp;
	mPrevProp 		= 0;
    }
    else
    {
    	for (TLPropagator *prop = TLVariable::sPropagator; prop;
	     prop = prop->mPrevProp)
	{
	    if (prop->mPrevProp == this)
	    {
		prop->mPrevProp = mPrevProp;
		mPrevProp 	= 0;
		break;
	    }
	}
    }
}
