/****************************************************************************
    $Id: problrep.cpp 501.0 1995/03/07 12:26:18 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLProblemRep.

    $Log: problrep.cpp $
    Revision 501.0  1995/03/07 12:26:18  RON
    Updated for TLX 5.01
    Revision 1.14  1995/02/22 12:33:14  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.13  1995/01/13  15:33:50  ron
    Corrected Revision keyword

    Revision 1.12  1995/01/12  13:40:41  ron
    Adapted to previous Searcher/ProblemRep model

    Revision 1.11  1995/01/05  15:26:16  ron
    Naming changes

    Revision 1.10  1994/11/16  15:35:08  ron
    Added module info; rearranged #include directives

    Revision 1.9  1994/10/13  11:50:02  ron
    Moved PreProcess() to this source file

    Revision 1.8  1994/10/07  16:59:39  ron
    Changed UnregisterSearcher() to DeregisterSearcher()

    Revision 1.7  1994/10/06  17:42:38  ron
    Changed wording of destruction check

    Revision 1.6  1994/10/05  18:32:26  ron
    Replaced destructor assertion with unlink operation + warning

    Revision 1.5  1994/09/28  14:11:49  ron
    Added mSearcher data member

    Revision 1.4  1994/09/27  20:21:53  ron
    Changed path separator from / to \

    Revision 1.3  1994/09/26  15:38:03  ron
    Changed include file references

    Revision 1.2  1994/09/06  14:06:42  ron
    Implemented InitialExpansion()

    Revision 1.1  1994/08/16  18:12:50  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\searcher.h>

/*-------------------------------------------------------------------------*/
    TLProblemRep::TLProblemRep()

/*  Constructor. Clears data members.
---------------------------------------------------------------------------*/
: mSearcher(0)
{
}

/*-------------------------------------------------------------------------*/
    TLProblemRep::~TLProblemRep()

/*  Destructor. Checks that it is not currently linked to a searcher.
---------------------------------------------------------------------------*/
{
    if (mSearcher)
    {
	TLX_TRACE_ERROR(TLX, ("ProblemRep linked to Searcher on destruction"));
	if (mSearcher->mProblemRep == this)
	    mSearcher->DeregisterProblemRep();
    	TLX_ASSERT_NULL(mSearcher);
    }
}

/*-------------------------------------------------------------------------*/
    size_t TLProblemRep::CreateInitialProblem(TLProblemList &aList)

/*  Called to create the initial problems in the search tree. The default
    implementation calls GenerateBranches() with an initial argument of 0.
---------------------------------------------------------------------------*/
{
    return GenerateBranches(0, aList);
}

/*-------------------------------------------------------------------------*/
    void TLProblemRep::LeaveState(TLProblemState *)

/*  Default clean-up step, which does nothing.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    void TLProblemRep::PostProcess()

/*  Default postprocessing step, which does nothing.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    bool TLProblemRep::PreProcess()

/*  Default preprocessing step, which will always succeed.
---------------------------------------------------------------------------*/
{
    return true;
}

