/****************************************************************************
    $Id: problist.cpp 501.0 1995/03/07 12:26:18 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLProblemList.

    $Log: problist.cpp $
    Revision 501.0  1995/03/07 12:26:18  RON
    Updated for TLX 5.01
    Revision 1.11  1995/02/28 15:12:22  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.10  1995/01/12  13:40:28  ron
    Small formatting changes

    Revision 1.9  1995/01/06  15:56:53  ron
    Adapted to new Searcher/Problem model

    Revision 1.8  1995/01/05  15:26:03  ron
    Naming changes

    Revision 1.7  1994/11/16  15:41:34  ron
    Added module info; rearranged #include directives

    Revision 1.6  1994/10/10  16:52:30  ron
    Changed to <tlx\solve\searcher.h>

    Revision 1.5  1994/10/05  18:41:08  ron
    Added support for Watcom C++

    Revision 1.4  1994/09/28  14:19:51  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:38  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:44:02  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:06  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

//-----	System headers

#include <iostream.h>
#include <stdio.h>

//----- Library headers

#include <tlx\501\solve\searcher.h>

/*---------------------------------------------------------------------------
    Template instantiations
---------------------------------------------------------------------------*/

#if defined(THINK_CPLUS)
    #include "ptrseq.cpp"
    #pragma template TLPtrSeq<TLProblemState>;
#elif defined(__BORLANDC__) || defined(_MSC_VER) || defined(__SC__) || defined(__WATCOMC__)
    #include <tlx\501\template\ptrseq.cpp>
#elif defined(__SUNPRO_CC)
    #include <tlx\501\template\ptrseq.cpp>
#elif defined(__IBMCPP__)
  #if __IBMCPP__ < 300
    #pragma implementation("tlx\\template\\ptrseq.cpp")
  #else
    #include <tlx\501\template\ptrseq.cpp>
  #endif
#else
    #error Unsupported compiler; contact Tarma Software Research
#endif

/*-------------------------------------------------------------------------*/
    TLProblemList::TLProblemList(TLProblemState *aProblem)

/*  Constructor. Creates a node list with a single subproblem and no
    ability to expand. Also sets the sequence to be owner of the nodes
    stored in it, and sets the proper sorting function.
---------------------------------------------------------------------------*/
: TLPtrSeq<TLProblemState>(aProblem)
{
    TLX_ASSERT_PTR(aProblem);

    BecomeOwner(true);
    SetCompare(CompareProblems);
}

/*-------------------------------------------------------------------------*/
    TLProblemList::TLProblemList(size_t aCap, size_t aDelta)

/*  Constructor. Creates a node list with the given initial capacity and
    expansion factor. Also sets the sequence to be owner of the nodes
    stored in it, and sets the proper sorting function.
---------------------------------------------------------------------------*/
: TLPtrSeq<TLProblemState>(aCap, aDelta)
{
    BecomeOwner(true);
    SetCompare(CompareProblems);
}

/*-------------------------------------------------------------------------*/
    int TLProblemList::CompareProblems(
    	const void *	aProblem1,
	const void *	aProblem2)

/*  Static member function that compares two subproblems by their ranking.
    Returns: < 0 if the first one is less than the second, 0 if they are
    equal, and > 0 if the first one is larger than the second one.
---------------------------------------------------------------------------*/
{
    double diff = RECAST(const TLProblemState *, aProblem1)->GetRank() -
		  RECAST(const TLProblemState *, aProblem2)->GetRank();

    return (diff < 0.0) ? -1 : (diff > 0.0) ? 1 : 0;
}
