/****************************************************************************
    $Id: nodecon.cpp 501.0 1995/03/07 12:26:18 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of the TLNodeCon class. This class represents a unary
    constraint in the CSP framework.

    $Log: nodecon.cpp $
    Revision 501.0  1995/03/07 12:26:18  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:18  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:58:05  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:41:28  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:52:17  ron
    Changed to <tlx\solve\csp.h>

    Revision 1.4  1994/09/28  14:19:36  ron
    Added WatchVar() and UnwatchVar()

    Revision 1.3  1994/09/27  20:22:37  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:43:53  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:05  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\csp.h>

/*-------------------------------------------------------------------------*/
    TLNodeCon::TLNodeCon(TLVariable &v)

/*  Default constructor. Initializes the variable that is referenced by the
    constraint.
---------------------------------------------------------------------------*/
: mVar(v)
{
}

/*-------------------------------------------------------------------------*/
    void TLNodeCon::UnwatchVar()

/*  Removes watches from the variable, i.e. removes the current constraint
    from its list of dependent constraints.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(mVar.Constraints().Contains(this));
    mVar.RemoveConstraint(this);
}

/*-------------------------------------------------------------------------*/
    void TLNodeCon::WatchVar()

/*  Sets watches on the variables, i.e. adds the current constraint to
    its list of dependent constraints.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!mVar.Constraints().Contains(this));
    mVar.AddConstraint(this);
}

