/****************************************************************************
    $Id: modinfo.cpp 501.0 1995/03/07 12:26:16 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLModuleInfo.

    $Log: modinfo.cpp $
    Revision 501.0  1995/03/07 12:26:16  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:30:18  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1995/01/06  15:58:04  ron
    Corrected Revision keyword

    Revision 1.1  1994/11/16  15:41:20  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <iomanip.h>

/*---------------------------------------------------------------------------
    Static variables
---------------------------------------------------------------------------*/

#ifdef _TLXDBG
int32		TLModuleInfo::sModCount;	// Initialized to 0
#endif
TLModuleInfo *	TLModuleInfo::sChain;		// Initialized to 0
TLModuleInfo 	TLModuleInfo::sNullInfo("(No filename)", "(No version)",
					"(No date)");

/*-------------------------------------------------------------------------*/
    TLModuleInfo::TLModuleInfo(
    	const char *aFile, const char *aVer, const char *aDT
    )

/*  Constructor. Links the instance into the global chain of modules.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aFile);
    TLX_ASSERT_PTR(aVer);
    TLX_ASSERT_PTR(aDT);

    mFilename = aFile;
    mVersion  = aVer;
    mDateTime = aDT;

    // Make this instance the new head of the global list. This will cause
    // the modules to appear in reverse order of initialization, but that
    // will make unlinking a lot cheaper (assuming that the order of
    // destruction is the opposite of the construction order). It is also
    // much faster to start with, which is important since this code will
    // typically be executed as part of the global application initialization
    // before any user code is run.
    //
    // We rely on the fact that the static 'sChain' pointer is statically
    // initialized, before any dynamic initialization code is run.

    TLX_ASSERT(sModCount > 0 || sChain == 0);
    mNext  = sChain;
    sChain = this;
    TLX_DEBUG_CODE(sModCount++;)
}

/*-------------------------------------------------------------------------*/
    TLModuleInfo::~TLModuleInfo()

/*  Destructor. Unlinks the current instance from the global chain.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(sModCount > 0);
    TLX_ASSERT_PTR(sChain);

    // If the order of destruction is the exact opposite of the order of
    // initialization, removal should be fast and simple: the currently
    // destructed instance will always be the head of the chain.

    if (this == sChain)
	sChain = mNext;
    else
    {
	// Find the precursor to this instance, then bridge the instance
	TLModuleInfo *rover;
	for (rover = sChain; rover; rover = rover->mNext)
	{
	    if (rover->mNext == this)
	    {
		rover->mNext = mNext;
		break;
	    }
	}

	// Check that the instance was found
	TLX_ASSERT_PTR(rover);
    }

    mNext = 0;
    TLX_DEBUG_CODE(sModCount--;)
}

/*-------------------------------------------------------------------------*/
    void TLModuleInfo::PrintAll(ostream &os)

/*  Static member function that prints information about all accessible
    modules. Due to the way instances are linked at creation, the printed
    order is the opposite of the initialization order.
---------------------------------------------------------------------------*/
{
    if (sChain)
    {
	TLX_DEBUG_CODE(int32 cnt = 0;)

	for (TLModuleInfo *rover = sChain; rover; rover = rover->mNext)
	{
	    TLX_DEBUG_CODE(cnt++;)
	    if (rover == &sNullInfo)
		continue;
	    rover->PrintOn(os) << "\n";
	}
	TLX_ASSERT(cnt == sModCount);
    }
    else
	os << "(No modules found)\n";
}

/*-------------------------------------------------------------------------*/
    ostream &TLModuleInfo::PrintOn(ostream &os) const

/*  Prints information about the current module on the given stream.
---------------------------------------------------------------------------*/
{
    long oldf = os.setf(ios::left, ios::adjustfield);
    os << setw(30) << Filename() << " " << setw(20) << Version()
    	<< " " << DateTime();
    os.setf(oldf, ios::adjustfield);
    return os;
}

#ifdef _TLXDBG

const char *TLModuleInfo::Filename() const
{
    TLX_ASSERT_PTR(mFilename);
    return mFilename;
}

const char *TLModuleInfo::Version() const
{
    TLX_ASSERT_PTR(mVersion);
    return mVersion;
}

const char *TLModuleInfo::DateTime() const
{
    TLX_ASSERT_PTR(mDateTime);
    return mDateTime;
}

#endif
