/****************************************************************************
    $Id: iter.cpp 501.0 1995/03/07 12:26:16 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLIter and TLPrintFormat.

    $Log: iter.cpp $
    Revision 501.0  1995/03/07 12:26:16  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:16  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1995/01/06  15:57:57  ron
    Corrected Revision keyword

    Revision 1.3  1994/11/16  15:40:26  ron
    Added module info; rearranged #include directives

    Revision 1.2  1994/09/27  20:22:35  ron
    Changed path separator from / to \

    Revision 1.1  1994/09/26  15:43:44  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\iter.h>

/*-------------------------------------------------------------------------*/
    TLPrintFormat::TLPrintFormat()

/*  Default constructor. Initializes formatting strings to empty.
---------------------------------------------------------------------------*/
{
    mLeader = mPresep = mPostsep = mTrailer = "";
}

/*-------------------------------------------------------------------------*/
    TLPrintFormat::TLPrintFormat
    (
    	const char *	aLeader,
	const char *	aPresep,
	const char *	aPostsep,
	const char *	aTrailer
    )

/*  Constructor. Uses its arguments to initialize the formatting strings.
---------------------------------------------------------------------------*/
{
    mLeader  = aLeader;
    mPresep  = aPresep;
    mPostsep = aPostsep;
    mTrailer = aTrailer;
}

/*-------------------------------------------------------------------------*/
    TLIter::TLIter()

/*  Default constructor. Resets state.
---------------------------------------------------------------------------*/
{
    mState = stReset;
}

/*-------------------------------------------------------------------------*/
    TLIter::~TLIter()

/*  Destructor. Does nothing, but is declared virtual for derivation.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    bool TLIter::Next()

/*  Called to advance the position of the iterator to the next element in
    the associated collection (if any). If the function returns true, the
    next element is available through the appropriate Peek() function,
    else the iteration is finished (and must be reset by Reset()).
---------------------------------------------------------------------------*/
{
    switch (mState)
    {
	case stReset:			// Reset - go to first
	    mState = FirstPos() ? stValid : stEnd;
	    break;

	case stValid:			// Valid - advance to next
	    mState = NextPos() ? stValid : stEnd;
	    break;

	case stEnd:			// At the end
	    break;

	default:
	    TLX_ASSERT_UNREACHABLE;
	    break;
    }
    return IsValid();
}

/*-------------------------------------------------------------------------*/
    void TLIter::Reset()

/*  Default reset operation. Resets the state of the iterator. If derived
    classes need to reset more than that, they should override this
    function (and adapt their constructor accordingly).
---------------------------------------------------------------------------*/
{
    mState = stReset;
}

