/****************************************************************************
    $Id: getopt.cpp 501.0 1995/03/07 12:26:14 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of tlGetOpt().

    $Log: getopt.cpp $
    Revision 501.0  1995/03/07 12:26:14  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:14  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:50  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:39:46  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/05  18:38:23  ron
    Renamed TLx...() functions to tl...()

    Revision 1.4  1994/09/28  14:18:37  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:28  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:43:00  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:04  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <stdio.h>
#include <string.h>
#include <tlx\501\cmdapp.h>

/*---------------------------------------------------------------------------
    Global variables
---------------------------------------------------------------------------*/

int    _TLXDATA	gOptInd = 1;	// Index of next argument
int    _TLXDATA	gOptErr = 1;	// Nonzero enables arre message
char * _TLXDATA	gOptArg = 0;	// Pointer to current option argument

/*-------------------------------------------------------------------------*/
    int _TLXFUNC tlGetOpt(int argc, char *argv[], const char *opts)

/*  Parses the command line options, UNIX System V style. Standard option
    syntax is:

    	option ::= SW [optLetter]* [argLetter space* argument]

    where:

	- SW is either '/' or '-', according to the native platform
	  conventions:
	  - MS-DOS: current setting of the switchar (int 21h function 37h).
	  - OS/2: always '/'
	  - UNIX: always '-'
	- there is no space before any optLetter or argLetter.
	- opt/arg letters are alphabetic, not punctuation characters.
	- optLetters, if present, must be matched in opts.
	- argLetters, if present, are found in opts followed by ':'.
	- argument is any white-space delimited string.	 Note that it
	  can include the SW character.
	- upper and lower case letters are distinct.

	There may be multiple option clusters on a command line, each
	beginning with a SW, but all must appear before any non-option
	arguments (arguments not introduced by SW).  Opt/arg letters may
	be repeated: it is up to the caller to decide if that is an error.

	The character SW appearing alone as the last argument is an error.
	The lead-in sequence SWSW ("--" or "//") causes itself and all the
	rest of the line to be ignored (allowing non-options which begin
	with the switch char).

	The string *opts allows valid opt/arg letters to be recognized.
	argLetters are followed with ':'.  Getopt() returns the value of
	the option character found, or EOF if no more options are in the
	command line. If option is an argLetter then the global gOptArg is
	set to point to the argument string (having skipped any white-space).

	The global gOptInd is initially 1 and is always left as the index
	of the next argument of argv[] which getopt has not taken.  Note
	that if "--" or "//" are used then gOptInd is stepped to the next
	argument before getopt() returns EOF.

	If an error occurs, that is an SW char precedes an unknown letter,
	then getopt() will return a '?' character and normally prints an
	error message via perror(). If the global variable gOptErr is set
	to false (zero) before calling getopt() then the error message is
	not printed.

	For example, if the MSDOS switch char is '/' (the MSDOS norm) and

		*opts == "A:F:PuU:wXZ:"

	then 'P', 'u', 'w', and 'X' are option letters and 'F', 'U', 'Z'
	are followed by arguments.  A valid command line may be:

		aCommand  /uPFPi /X /A L someFile

	where:

	- 'u' and 'P' will be returned as isolated option letters.
	- 'F' will return with "Pi" as its argument string.
	- 'X' is an isolated option.
	- 'A' will return with "L" as its argument.
	- "someFile" is not an option, and terminates getopt().	 The
	caller may collect remaining arguments using argv pointers.

    Parameters:
	argc	= number of command line arguments
	argv	= array of argument pointers
	opts	= string describing options (see above)

    Return value:
	Value of the next option character, or EOF if no more options follow.
---------------------------------------------------------------------------*/
{
    static char *nextopt = NULL;	/* remember next option char's location */
    const char *optP;
    char ch;

    TLX_ASSERT_PTR(argv);
    TLX_ASSERT_PTR(opts);

    if (gOptInd <= argc)
    {
	if (nextopt == NULL)		// Ran out of previous argument
	{
	    if ((nextopt = argv[gOptInd]) == NULL || *(nextopt++) != gOptionChar)
		goto gopEOF;

	    if (*nextopt == gOptionChar)	// Repeated switch character
	    {
		gOptInd++;
		goto gopEOF;
	    }
	}

	if ((ch = *(nextopt++)) == 0)	// Null option
	{
	    gOptInd++;
	    goto gopEOF;
	}

	if (':' == ch  ||  (optP = strchr(opts, ch)) == NULL)
	    goto gopError;

	if (':' == *(++optP))
	{
	    gOptInd++;
	    if (*nextopt == 0)
	    {
		if (gOptInd > argc)  goto  gopError;
		nextopt = argv[gOptInd++];
	    }
	    gOptArg = nextopt;
	    nextopt = NULL;
	}
	else
	{
	    if (*nextopt == 0)
	    {
		gOptInd++;
		nextopt = NULL;
	    }
	    gOptArg = NULL;
	}
	return ch;
    }

gopEOF:
    gOptArg = nextopt = NULL;
    return EOF;

gopError:
    gOptArg = NULL;
    return '?';
}
