/****************************************************************************
    $Id: except.cpp 501.0 1995/03/07 12:26:14 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Implementation of exception handling functions.

    $Log: except.cpp $
    Revision 501.0  1995/03/07 12:26:14  RON
    Updated for TLX 5.01
    Revision 1.12  1995/01/31 16:30:14  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.11  1995/01/06  15:57:48  ron
    Corrected Revision keyword

    Revision 1.10  1995/01/05  15:24:18  ron
    Changed exception reporting format slightly

    Revision 1.9  1994/11/16  15:39:26  ron
    Moved individual exception classes to separate files
    Added module info; rearranged #include directives

    Revision 1.8  1994/10/05  18:38:09  ron
    Renamed TLx...() functions to tl...()

    Revision 1.7  1994/09/28  14:18:30  ron
    Removed Macintosh-style #include references

    Revision 1.6  1994/09/27  20:22:26  ron
    Changed path separator from / to \

    Revision 1.5  1994/09/26  15:42:52  ron
    Changed include file references

    Revision 1.4  1994/09/12  14:54:44  ron
    Implemented PrintOn() and operator << overloading for TLException

    Revision 1.3  1994/09/07  15:43:02  ron
    Implemented class TLXResize

    Revision 1.2  1994/09/06  14:10:10  ron
    Added TLXAssert and TLXIos exceptions

    Revision 1.1  1994/08/16  18:13:04  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <tlx\501\except.h>

/*-------------------------------------------------------------------------*/
    void _TLXFUNC _tlThrow(const TLException &aX)

/*  Helper function to simulate an exception if there is no compiler support
    for it. It displays a diagnostic that allows the user to choose whether
    or not to continue.
---------------------------------------------------------------------------*/
{
    TLAssert::Diagnostic(TLAssert::dfError, aX.Locus().mFile, aX.Locus().mLine,
                  "Exception: %s", aX.Description());
}

/*---------------------------------------------------------------------------
    Implementation of class TLException
---------------------------------------------------------------------------*/

const size_t     TLException::sBufferSize = 256;
char            TLException::sBuffer[TLException::sBufferSize];

/*-------------------------------------------------------------------------*/
    TLException::TLException(const TLXLocus &aLocus)

/*  Constructor, initializes locus member.
---------------------------------------------------------------------------*/
: mLocus(aLocus)
{
}

/*-------------------------------------------------------------------------*/
    TLException::~TLException()

/*  Destructor. Does nothing, but is declared virtual for derivation.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    const char *TLException::Description() const

/*  Returns a pointer to a string describing the exception. The description
    does *not* include the locus.
---------------------------------------------------------------------------*/
{
    return "TLX exception";
}

/*-------------------------------------------------------------------------*/
    ostream &TLException::PrintOn(ostream &os) const

/*  Prints a description of the exception on the given stream.
---------------------------------------------------------------------------*/
{
    return os << Description() << " (from: " << mLocus.mFile << " ["
       	<< mLocus.mLine << "])";
}

/*-------------------------------------------------------------------------*/
    void TLException::Report() const

/*  Reports the exception (description + locus) with the aid of the
    diagnostic output functions.
---------------------------------------------------------------------------*/
{
    _tlThrow(*this);
}

/*-------------------------------------------------------------------------*/
    ostream & _TLXFUNC operator <<(ostream &os, const TLException &x)

/*  Overloads the output operator for exceptions.
---------------------------------------------------------------------------*/
{
    return x.PrintOn(os);
}

