/****************************************************************************
    $Id: domelem.cpp 501.0 1995/03/07 12:26:14 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLDomainElement.

    $Log: domelem.cpp $
    Revision 501.0  1995/03/07 12:26:14  RON
    Updated for TLX 5.01
    Revision 1.8  1995/02/28 15:11:20  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:44  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:39:08  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:49:51  ron
    Changed to <tlx\solve\ac6.h>

    Revision 1.4  1994/09/28  14:17:49  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:23  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:42:34  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:02  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\ac6.h>

/*---------------------------------------------------------------------------
    Template source code
---------------------------------------------------------------------------*/

#if defined(THINK_CPLUS)
    #include "assoc.cpp"
    #include "pointer.cpp"
    #pragma template_access public
    #pragma template TLAssoc<tVarValue, TLSupportPtr>
#elif defined(__BORLANDC__) || defined(_MSC_VER) || defined(__SC__) || defined(__WATCOMC__)
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\pointer.cpp>
#elif defined(__SUNPRO_CC)
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\pointer.cpp>
#elif defined(__IBMCPP__)
  #if __IBMCPP__ < 300
    #pragma implementation("tlx\\template\\assoc.cpp")
    #pragma implementation("tlx\\template\\pointer.cpp")
  #else
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\pointer.cpp>
  #endif
#else
    #error Unsupported compiler; contact Tarma Software Research
#endif

/*-------------------------------------------------------------------------*/
    TLDomainElement::TLDomainElement(tVarValue aValue)

/*  Constructor, also doubles as default constructor.
---------------------------------------------------------------------------*/
: TLAssoc<tVarValue, TLSupportPtr>(aValue, 0)
{
    SupportList() = new TLSupportList;
    SupportList()->BecomeOwner();
}

/*-------------------------------------------------------------------------*/
    void TLDomainElement::AddSupport(const VV_Assoc &aVV)

/*  Adds the given variable/value pair to the support list of the domain
    element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR((TLSupportList *)SupportList());

#ifdef _TLXDBG
    TLVarValueLink *vvlink = new TLVarValueLink(aVV);
    TLX_ASSERT_PTR(vvlink);
    SupportList()->Append(vvlink);
#else
    SupportList()->Append(new TLVarValueLink(aVV));
#endif
}

/*-------------------------------------------------------------------------*/
    void TLDomainElement::ClearSupport()

/*  Clears the entire support list of the domain element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR((TLSupportList *)SupportList());
    SupportList()->RemoveAll();
}

/*-------------------------------------------------------------------------*/
    bool TLDomainElement::NextIter(iter_t &aIter)

/*  Advances the iterator in the support list, returning nonzero if it
    is still valid after the operation.
---------------------------------------------------------------------------*/
{
    TLVarValueLink *vvlink = (TLVarValueLink *)aIter.ptr;
    TLX_ASSERT_PTR(vvlink);

#ifdef _TLXDBG
    // Check that the passed-in iterator really does point into the
    // support list.

    TLX_ASSERT_PTR((TLSupportList *)SupportList());
    TLVarValueLink *rover;

    for (rover = SupportList()->PeekHead(); rover;
	 rover = (TLVarValueLink *)rover->Next())
    {
	if (*rover == *vvlink)
	    break;
    }

    TLX_ASSERT_PTR(rover);
#endif

    aIter.ptr = vvlink->Next();
    return aIter.ptr != 0;
}

/*-------------------------------------------------------------------------*/
    TLDomainElement &TLDomainElement::operator =(const TLDomainElement &aEl)

/*  Overloading of the assignment operator.
---------------------------------------------------------------------------*/
{
    if (this != &aEl)
    {
	Key()   = aEl.Key();
	Value() = aEl.Value();
    }
    return *this;
}

/*-------------------------------------------------------------------------*/
    const TLVarValueLink *TLDomainElement::PeekIter(const iter_t &aIter) const

/*  Returns a reference to the element to which the iterator points.
---------------------------------------------------------------------------*/
{
    TLVarValueLink *vvlink = (TLVarValueLink *)aIter.ptr;
    TLX_ASSERT_PTR(vvlink);

#ifdef _TLXDBG
    // Check that the passed-in iterator really does point into the
    // support list.

    TLX_ASSERT_PTR((TLSupportList *)SupportList());
    TLVarValueLink *rover;

    for (rover = SupportList()->PeekHead(); rover;
	 rover = (TLVarValueLink *)rover->Next())
    {
	if (*rover == *vvlink)
	    break;
    }

    TLX_ASSERT_PTR(rover);
#endif

    return vvlink;
}

/*-------------------------------------------------------------------------*/
    void TLDomainElement::RemoveSupport(const VV_Assoc &aVV)

/*  Removes the given variable/value pair from the support list of the
    domain element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR((TLSupportList *)SupportList());

    for (TLVarValueLink *rover = SupportList()->PeekHead(); rover;
	 rover = (TLVarValueLink *)rover->Next())
    {
	if (*rover == aVV)
	{
	    SupportList()->Extract(rover);
	    delete rover;
	    return;
	}
    }
}

/*-------------------------------------------------------------------------*/
    bool TLDomainElement::ResetIter(iter_t &aIter)

/*  Resets the iterator to point at the first element in the support list
    of the domain element. Returns nonzero if the iterator is valid after
    the operation.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR((TLSupportList *)SupportList());
    aIter.ptr = SupportList()->PeekHead();
    return aIter.ptr != 0;
}

