/****************************************************************************
    $Id: domac6.cpp 501.0 1995/03/07 12:26:14 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLDomainAC6.

    $Log: domac6.cpp $
    Revision 501.0  1995/03/07 12:26:14  RON
    Updated for TLX 5.01
    Revision 1.8  1995/02/28 15:10:52  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:42  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:38:54  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:49:24  ron
    Changed to <tlx\solve\ac6.h>

    Revision 1.4  1994/09/28  14:17:35  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:20  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:42:15  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:13:01  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\ac6.h>

/*---------------------------------------------------------------------------
    Template source code
---------------------------------------------------------------------------*/

#if defined(THINK_CPLUS)
    #include "assoc.cpp"
    #include "seq.cpp"
    #pragma template_access public
    #pragma template TLSeq<TLDomainElement>
#elif defined(__BORLANDC__) || defined(__SC__) || defined(__WATCOMC__)
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\seq.cpp>
#elif defined(__SUNPRO_CC)
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\seq.cpp>
#elif defined(__IBMCPP__)
  #if __IBMCPP__ < 300
    #pragma implementation("tlx\\template\\assoc.cpp")
    #pragma implementation("tlx\\template\\seq.cpp")
  #else
    #include <tlx\501\template\assoc.cpp>
    #include <tlx\501\template\seq.cpp>
  #endif
#else
    #error Unsupported compiler; contact Tarma Software Research
#endif

/*-------------------------------------------------------------------------*/
    TLDomainAC6::TLDomainAC6(size_t aCap, size_t aDelta)

/*  Constructor.
---------------------------------------------------------------------------*/
: TLSeq<TLDomainElement>(aCap, aDelta)
{
    SetCompare(DECompare);
}

/*-------------------------------------------------------------------------*/
    int TLDomainAC6::DECompare
    (
    	const TLDomainElement &	aEl1,
	const TLDomainElement &	aEl2
    )

/*  Static function to compare two domain elements in the sequence.
---------------------------------------------------------------------------*/
{
    tVarValue diff = aEl1.PeekValue() - aEl2.PeekValue();
    return (diff < 0) ? -1 : (diff > 0) ? 1 : 0;
}

/*-------------------------------------------------------------------------*/
    index_t TLDomainAC6::EqualOrNextIndexOf(tVarValue aValue) const

/*  Returns the index of the given value in the domain, or of the next
    higher element in the domain. This assumes that the domain is sorted.
---------------------------------------------------------------------------*/
{
    TLDomainElement el(aValue);

    for (index_t index = Mini(); index <= Maxi(); index++)
    {
	if (DECompare(PeekAt(index), el) >= 0)
	    return index;
    }
    return Maxi() + 1;
}

/*-------------------------------------------------------------------------*/
    TLDomainElement &TLDomainAC6::GetElement(tVarValue aValue)

/*  Returns a reference to the domain element containing the given value.
---------------------------------------------------------------------------*/
{
    index_t index = IndexOfValue(aValue);
    if (!IsValidIndex(index))
    	THROW(TLXNotFound(LOCUS));
    return PeekAt(index);
}

/*-------------------------------------------------------------------------*/
    const TLDomainElement &TLDomainAC6::GetElement(tVarValue aValue) const

/*  Returns a reference to the domain element containing the given value.
---------------------------------------------------------------------------*/
{
    index_t index = IndexOfValue(aValue);
    if (!IsValidIndex(index))
    	THROW(TLXNotFound(LOCUS));
    return PeekAt(index);
}

/*-------------------------------------------------------------------------*/
    index_t TLDomainAC6::IndexOfValue(tVarValue aValue) const

/*  Returns the index of the given value in the domain.
---------------------------------------------------------------------------*/
{
    TLDomainElement el(aValue);

    for (index_t index = Mini(); index <= Maxi(); index++)
    {
	if (DECompare(PeekAt(index), el) == 0)
	    return index;
    }
    return Maxi() + 1;
}

