/****************************************************************************
    $Id: dlink.cpp 501.0 1995/03/07 12:26:12 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLDLink. This class represents an element in the
    various list structures. Its member functions are geared towards linear
    list implementations, so a circular list implementation must take some
    extra care.

    $Log: dlink.cpp $
    Revision 501.0  1995/03/07 12:26:12  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:30:10  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1995/01/06  15:57:39  ron
    Corrected Revision keyword

    Revision 1.5  1994/11/16  15:38:37  ron
    Added module info; rearranged #include directives

    Revision 1.4  1994/09/28  14:17:12  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:16  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:41:51  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:12:59  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\dlists.h>		// Class declaration

/*-------------------------------------------------------------------------*/
    TLDLink::TLDLink()

/*  Default constructor. Sets both link fields to 0.
---------------------------------------------------------------------------*/
: mNext(0), mPrev(0)
{
}

/*-------------------------------------------------------------------------*/
    TLDLink::TLDLink(const TLDLink &)

/*  Copy constructor. Does not copy the link fields, but sets them to 0.
---------------------------------------------------------------------------*/
: mNext(0), mPrev(0)
{
}

/*-------------------------------------------------------------------------*/
    TLDLink::~TLDLink()

/*  Destructor. Makes sure that the instance is unlinked from its
    neighbours.
---------------------------------------------------------------------------*/
{
    Unlink();
}

/*-------------------------------------------------------------------------*/
    void TLDLink::Append(TLDLink *aLink)

/*  Inserts 'aLink' after the current TLDLink. The current TLDLink must be
    part of a chain, and 'aLink' must not currently be linked. It is an
    error to pass a 0 pointer.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aLink);
    TLX_ASSERT_NULL(aLink->mNext);
    TLX_ASSERT_NULL(aLink->mPrev);

    aLink->mNext = mNext;
    aLink->mPrev = this;
    if (mNext)
    {
	TLX_ASSERT(mNext->mPrev == this);
	mNext->mPrev = aLink;
    }
    mNext = aLink;
}

/*-------------------------------------------------------------------------*/
    TLDLink &TLDLink::operator =(const TLDLink &)

/*  Overloading of the assignment operator. Does not copy the link fields.
---------------------------------------------------------------------------*/
{
    return *this;
}

/*-------------------------------------------------------------------------*/
    void TLDLink::Prepend(TLDLink *aLink)

/*  Inserts another link before the current one. The TLDLink instance
    to be inserted must not currently be part of a chain. Also, it is
    an error to pass a 0 pointer.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aLink);
    TLX_ASSERT_NULL(aLink->mNext);
    TLX_ASSERT_NULL(aLink->mPrev);

    aLink->mNext = this;
    aLink->mPrev = mPrev;
    if (mPrev)
    {
	TLX_ASSERT(mPrev->mNext == this);
	mPrev->mNext = aLink;
    }
    mPrev = aLink;
}

/*-------------------------------------------------------------------------*/
    void TLDLink::Unlink()

/*  Removes the current TLDLink from the list of which it is part.
---------------------------------------------------------------------------*/
{
    if (mNext)
    {
	TLX_ASSERT(mNext->mPrev == this);
	mNext->mPrev = mPrev;
    }
    if (mPrev)
    {
	TLX_ASSERT(mPrev->mNext == this);
	mPrev->mNext = mNext;
    }
    mNext = mPrev = 0;
}

