/****************************************************************************
    $Id: cssubprb.cpp 501.0 1995/03/07 12:26:12 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLCSSubProblem.

    $Log: cssubprb.cpp $
    Revision 501.0  1995/03/07 12:26:12  RON
    Updated for TLX 5.01
    Revision 1.9  1995/02/22 12:22:58  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.8  1995/01/12  13:39:23  ron
    Adapted to previous Searcher/ProblemRep model

    Revision 1.7  1995/01/08  11:45:36  ron
    Renamed TLCSProblem to TLCSSubProblem

    Revision 1.6  1995/01/06  15:56:51  ron
    Adapted to new Searcher/Problem model

    Revision 1.5  1995/01/05  15:23:18  ron
    Naming changes

    Revision 1.4  1994/11/16  15:37:59  ron
    Added module info; rearranged #include directives

    Revision 1.3  1994/10/10  16:48:24  ron
    Changed to <tlx\solve\stdcsp.h>

    Revision 1.2  1994/10/05  18:36:51  ron
    Added linking to associated variable

    Revision 1.1  1994/09/28  14:16:21  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\stdcsp.h>

/*-------------------------------------------------------------------------*/
    TLCSProblemState::TLCSProblemState(
	//TLProblemState *		aParent,
	TLVariable *		aVar
    )

/*  Constructor, also doubles as the default constructor. Links to the
    parent and the variable (if any).
---------------------------------------------------------------------------*/
//: TLProblemState(aParent), mVar(aVar)
: mVar(aVar)
{
    if (mVar) mVar->SetProblem(this);
}

/*-------------------------------------------------------------------------*/
    TLCSProblemState::~TLCSProblemState()

/*  Destructor. Unlinks from the variable.
---------------------------------------------------------------------------*/
{
    if (mVar && mVar->GetProblem() == this)
    	mVar->SetProblem(0);
}

