/****************************************************************************
    $Id: cspmonit.cpp 501.0 1995/03/07 12:26:10 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLCSPMonitor.

    $Log: cspmonit.cpp $
    Revision 501.0  1995/03/07 12:26:10  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:06  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1995/01/18  10:37:44  ron
    Simplified limit setting of per-depth statistics

    Revision 1.3  1995/01/12  13:38:47  ron
    Adapted to previous Searcher/ProblemRep model

    Revision 1.2  1995/01/08  11:44:16  ron
    Changed searcher depth type from int32 to int

    Revision 1.1  1995/01/06  15:56:48  ron
    Adapted to new Searcher/Problem model

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <iomanip.h>

#include <tlx\501\solve\stdcsp.h>

// Template source code

#include <tlx\501\template\array.cpp>
#include <tlx\501\template\stats1.cpp>

/*-------------------------------------------------------------------------*/
    TLCSPMonitor::TLCSPMonitor()

/*  Constructor.
---------------------------------------------------------------------------*/
{
    mPrevCount = 0;
}

/*-------------------------------------------------------------------------*/
    int TLCSPMonitor::DefaultEvents() const

/*  Returns the set of search events that the monitor is interested in.
---------------------------------------------------------------------------*/
{
    return TLSearcher::sePreProcess | TLSearcher::seProcess;
}

/*-------------------------------------------------------------------------*/
    void TLCSPMonitor::OnSearchEvent(
	TLSearcher *	aSearcher,
	const Event &	aEvent)

/*  Call-back for events handled by this monitor. It updates search
    statistics.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aSearcher);

    switch (aEvent.mCode)
    {
	case TLSearcher::sePreProcess:
	{
	    // The preprocess event is used to reset the statistics
	    // to resize the level branching array.

	    mChecks.Clear();
	    TLX_ASSERT_PTR(aSearcher->GetProblemRep());
	    mLevelChecks.SetLimits(0, aSearcher->GetProblemRep()->Size());
	    mPrevCount = 0;
	    break;
	}
	case TLSearcher::seProcess:
	{
	    // Whenever a problem is processed, the new number of constraint
	    // checks is noted.

	    int32 newcnt = TLConstraint::CheckCount();
	    if (newcnt < mPrevCount)
	    {
		TLX_TRACE_WARN(TLX, ("Constraint check count has been reset"));
		mPrevCount = newcnt;
	    }

	    int32 diff = newcnt - mPrevCount;
	    mPrevCount	= newcnt;

	    int depth = aSearcher->GetLevel();
	    TLX_ASSERT(depth >= mLevelChecks.Mini());
	    TLX_ASSERT(depth <= mLevelChecks.Maxi());
	    mChecks.Add(diff);
	    mLevelChecks[depth].Add(diff);
	    break;
	}

	// default: all others are ignored
    }
}

/*-------------------------------------------------------------------------*/
    ostream &TLCSPMonitor::PrintOn(ostream &os) const

/*  Function to print the contents of the monitor on the given stream,
    usually as part of the searcher's ReportStats() processing.
---------------------------------------------------------------------------*/
{
    os << "Overall constraint checks: " << mChecks << "\n";
    os << "Per-level checks for " << mLevelChecks.Size() << " levels:\n";

    for (index_t i = mLevelChecks.Mini(); i <= mLevelChecks.Maxi(); i++)
	os << setw(4) << i << " - " << mLevelChecks[i] << "\n";

    return os;
}

