/****************************************************************************
    $Id: constrai.cpp 501.0 1995/03/07 12:26:10 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of the TLConstraint class. This class is the abstract
    base class for all constraints in the CSP framework.

    $Log: constrai.cpp $
    Revision 501.0  1995/03/07 12:26:10  RON
    Updated for TLX 5.01
    Revision 1.10  1995/01/31 16:30:06  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.9  1995/01/13  15:30:45  ron
    Changed activation flag to activation count; this ensures that
    constraints with arity > 1 will remain deactivated until all
    connected variables are free

    Revision 1.8  1995/01/06  15:57:31  ron
    Corrected Revision keyword

    Revision 1.7  1994/11/16  15:37:45  ron
    Added module info; rearranged #include directives

    Revision 1.6  1994/10/10  16:47:20  ron
    Chnaged to <tlx\solve\csp.h>

    Revision 1.5  1994/10/05  18:36:31  ron
    Added conditional propagation

    Revision 1.4  1994/09/28  14:16:15  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:07  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:41:00  ron
    Added static constraint check counter

    Revision 1.1  1994/08/16  18:12:56  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\csp.h>

/*---------------------------------------------------------------------------
    Static data members
---------------------------------------------------------------------------*/

int32 TLConstraint::sCheckCount = 0;

/*-------------------------------------------------------------------------*/
    TLConstraint::TLConstraint()

/*  Constructor. Resets deactivation flag.
---------------------------------------------------------------------------*/
{
    mDeactiveCount = 0;
}

/*-------------------------------------------------------------------------*/
    TLConstraint::~TLConstraint()

/*  Destructor. Does nothing, but is declared virtual for derivation.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    void TLConstraint::Activate()

/*  Undoes a level of deactivation by decrementing the deactivation count.
---------------------------------------------------------------------------*/
{
    if (--mDeactiveCount < 0)
    {
	TLX_TRACE_WARN(TLX, ("More activations than deactivations"));
	mDeactiveCount = 0;
    }
}

/*-------------------------------------------------------------------------*/
    void TLConstraint::Deactivate()

/*  Deactivates the constraint by increasing its deactivation count. There
    must be a matching number of activations to make the constraint active
    again.
---------------------------------------------------------------------------*/
{
    if (mDeactiveCount < INT_MAX)
	++mDeactiveCount;
    else
	TLX_TRACE_WARN(TLX, ("Maximum number of deactivations exceeded"));
}

/*-------------------------------------------------------------------------*/
    bool TLConstraint::PropagateCond(TLVariable *aVar)

/*  Constraint propagation function. Will call the Propagate() implementation
    if the constraint is active, else will do nothing. Returns the result
    of Propagate(), or true if the constraint is not active.
---------------------------------------------------------------------------*/
{
    return IsActive() ? Propagate(aVar) : true;
}

