/****************************************************************************
    $Id: conac6.cpp 501.0 1995/03/07 12:26:10 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLConstraintAC6.

    $Log: conac6.cpp $
    Revision 501.0  1995/03/07 12:26:10  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:06  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:30  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:37:39  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:47:02  ron
    Changed to <tlx\solve\ac6.h>

    Revision 1.4  1994/09/28  14:16:07  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:06  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:40:45  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:12:56  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\solve\ac6.h>

/*-------------------------------------------------------------------------*/
    TLConstraintAC6::TLConstraintAC6
    (
    	TLVariableAC6 &	aVar1,
	TLVariableAC6 &	aVar2
    )

/*  Constructor.
---------------------------------------------------------------------------*/
: TLBinCon(aVar1, aVar2)
{
}

/*-------------------------------------------------------------------------*/
    TLVariableAC6 &TLConstraintAC6::OppositeOf(TLVariableAC6 &aVar)

/*  Returns the variable that is the opposite of the given one in the
    constraint.
---------------------------------------------------------------------------*/
{
    return DYNACAST(TLVariableAC6 &, TLBinCon::OppositeOf(aVar));
}

/*-------------------------------------------------------------------------*/
    const TLVariableAC6 &TLConstraintAC6::OppositeOf
    (
    	const TLVariableAC6 &	aVar
    ) const

/*  Returns the variable that is the opposite of the given one in the
    constraint.
---------------------------------------------------------------------------*/
{
    return DYNACAST(const TLVariableAC6 &, TLBinCon::OppositeOf(aVar));
}

/*-------------------------------------------------------------------------*/
    TLVariableAC6 &TLConstraintAC6::Var1()

/*  Returns a reference to the first variable, with an appropriate type cast.
---------------------------------------------------------------------------*/
{
    return DYNACAST(TLVariableAC6 &, TLBinCon::Var1());
}

/*-------------------------------------------------------------------------*/
    const TLVariableAC6 &TLConstraintAC6::Var1() const

/*  Returns a reference to the first variable, with an appropriate type cast.
---------------------------------------------------------------------------*/
{
    return DYNACAST(const TLVariableAC6 &, TLBinCon::Var1());
}

/*-------------------------------------------------------------------------*/
    TLVariableAC6 &TLConstraintAC6::Var2()

/*  Returns a reference to the second variable, with an appropriate type cast.
---------------------------------------------------------------------------*/
{
    return DYNACAST(TLVariableAC6 &, TLBinCon::Var2());
}

/*-------------------------------------------------------------------------*/
    const TLVariableAC6 &TLConstraintAC6::Var2() const

/*  Returns a reference to the second variable, with an appropriate type cast.
---------------------------------------------------------------------------*/
{
    return DYNACAST(const TLVariableAC6 &, TLBinCon::Var2());
}
