/****************************************************************************
    $Id: cdcheck.cpp 501.0 1995/03/07 12:26:10 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLCDChecker.

    $Log: cdcheck.cpp $
    Revision 501.0  1995/03/07 12:26:10  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:30:06  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1995/01/06  15:57:28  ron
    Corrected Revision keyword

    Revision 1.1  1994/11/16  15:37:29  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <tlx\501\dispose.h>

/*-------------------------------------------------------------------------*/
    TLCDChecker::TLCDChecker()

/*  Constructor. Ensures that the object was not initialized and marks it
    as initialized.
---------------------------------------------------------------------------*/
{
#ifdef _TLXDBG
    // Note: this is slighly dangerous, since there is always a chance that
    // the storage contains the magic signature by coincidence.

    TLX_ASSERT(mState != osConstructed);
    mState = osConstructed;
#endif
}

/*-------------------------------------------------------------------------*/
    TLCDChecker::TLCDChecker(const TLCDChecker &)

/*  Copy constructor. Does not copy the check field, but checks and
    initializes it.
---------------------------------------------------------------------------*/
{
#ifdef _TLXDBG
    // Note: this is slighly dangerous, since there is always a chance that
    // the storage contains the magic signature by coincidence.

    TLX_ASSERT(mState != osConstructed);
    mState = osConstructed;
#endif
}

/*-------------------------------------------------------------------------*/
    TLCDChecker::~TLCDChecker()

/*  Destructor. Ensures that the object was initialized and marks it as
    destructed.
---------------------------------------------------------------------------*/
{
#ifdef _TLXDBG
    TLX_ASSERT(mState == osConstructed);
    mState = osDestructed;
#endif
}

/*-------------------------------------------------------------------------*/
    TLCDChecker &TLCDChecker::operator =(const TLCDChecker &)

/*  Assignment operator. Does not copy the check field (but checks it).
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(mState == osConstructed);
    return *this;
}

#ifdef _TLXDBG
/*-------------------------------------------------------------------------*/
    void TLCDChecker::AssertValid(const char *aFile, int aLine) const

/*  Checks the validity of the object, and generates a diagnostic if
    invalid. Should be called with the filename and line number of the
    location of the check.
---------------------------------------------------------------------------*/
{
    switch (mState) {
	case osConstructed:		// No problem
	    break;
	case osDestructed:		// Destroyed object reused
	    TLAssert::Diagnostic(TLAssert::dfError, aFile, aLine,
	    			 "Object has been destroyed");
	    break;
	default:			// Uninitialized object
	    TLAssert::Diagnostic(TLAssert::dfError, aFile, aLine,
	    			 "Object not initialized");
	    break;
    }
}
#endif
