/****************************************************************************
    $Id: btsrchrc.cpp 501.0 1995/03/07 12:26:10 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLBTSearcherRcsv. This class implements a
    domain-independent recursive backtrack search process.

    $Log: btsrchrc.cpp $
    Revision 501.0  1995/03/07 12:26:10  RON
    Updated for TLX 5.01
    Revision 1.16  1995/02/28 15:10:34  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.15  1995/01/12  13:38:12  ron
    Adapted to previous Searcher/ProblemRep model
    Added check on initial problems

    Revision 1.14  1995/01/06  15:55:59  ron
    Adapted to new Searcher/Problem model

    Revision 1.13  1995/01/05  15:21:56  ron
    Formatting and naming changes

    Revision 1.12  1994/11/16  15:37:20  ron
    Added module info; rearranged #include directives

    Revision 1.11  1994/10/11  19:04:17  ron
    Replaced DeadEnd() + SolveProblem() by ProcessProblem()

    Revision 1.10  1994/10/10  16:54:08  ron
    Added searcher description
    Added termination routine & checks

    Revision 1.9  1994/10/07  17:03:47  ron
    Removed direct references to problem representation and search statistics

    Revision 1.8  1994/10/05  18:42:05  ron
    Added support for Watcom C++

    Revision 1.7  1994/09/28  14:20:35  ron
    Removed Macintosh-style #include references

    Revision 1.6  1994/09/27  20:22:48  ron
    Changed path separator from / to \

    Revision 1.5  1994/09/26  15:45:54  ron
    Changed include file references

    Revision 1.4  1994/09/13  10:14:28  ron
    Adapted to changes in the TLProblemRep hierarchy
    Changed direct calls to problem representation EnterProblem()/LeaveProblem() to
    calls to the TLSearcher-based versions.

    Revision 1.3  1994/09/12  14:55:34  ron
    Adapted Search() implementation to changes in TLSearcher interface

    Revision 1.2  1994/09/06  14:09:00  ron
    Adapted to changes in search framework

    Revision 1.1  1994/08/16  18:13:09  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <stdio.h>
#include <tlx\501\solve\searcher.h>

/*---------------------------------------------------------------------------
    Template instantiations
---------------------------------------------------------------------------*/

#if defined(THINK_CPLUS)
    #include "pointer.cpp"
    #pragma template TLCountedPtr<TLProblemState>;
#elif defined(__BORLANDC__) || defined(_MSC_VER) || defined(__SC__) || defined(__WATCOMC__)
    #include <tlx\501\template\pointer.cpp>
#elif defined(__SUNPRO_CC)
    #include <tlx\501\template\pointer.cpp>
#elif defined(__IBMCPP__)
  #if __IBMCPP__ < 300
    #pragma implementation("tlx\\template\\pointer.cpp")
  #else
    #include <tlx\501\template\pointer.cpp>
  #endif
#else
    #error Unsupported compiler; contact Tarma Software Research
#endif

/*-------------------------------------------------------------------------*/
    TLBTSearcherRcsv::TLBTSearcherRcsv()

/*  Default constructor.
---------------------------------------------------------------------------*/
{
    mTerminate = false;
}

/*-------------------------------------------------------------------------*/
    const char *TLBTSearcherRcsv::Description() const

/*  Returns a description of the searcher.
---------------------------------------------------------------------------*/
{
    return "Recursive backtrack searcher";
}

/*-------------------------------------------------------------------------*/
    void TLBTSearcherRcsv::Search()

/*  Perfoms the actual search process. The function assumes that all
    parameters have been properly set up. It will find at most mMaxSol
    solutions and return when the lesser of all or mMaxSol solutions has
    been found.
---------------------------------------------------------------------------*/
{
    mTerminate = false;

    TLProblemList root(50, 50);
    if (CreateInitialProblem(root) < 1)
    {
	TLX_TRACE_WARN(TLX, ("No initial problems created - search aborted"));
	return;
    }
    StepForward(root);
}

/*-------------------------------------------------------------------------*/
    bool TLBTSearcherRcsv::StepForward(TLProblemList &aList)

/*  Performs a forward step in the search process. If the step succeeds,
    it calls itself recursively to do the next step. If it fails, it
    backtracks.

    If all variables have been instantiated when this function is called,
    it reports the solution and either stops the search process if
    sufficient solutions have been found, or continues with a backtrack to
    find the next solution (if any).

    Returns nonzero if the search is successful and complete; zero if we
    reach a dead end or want to backtrack to find subsequent solutions.
---------------------------------------------------------------------------*/
{
    while (!mTerminate && !aList.IsEmpty())
    {
	TLProblemState *curproblem = aList.ExtractFirst();
	TLX_ASSERT_PTR(curproblem);
	EnterState(curproblem);

	if (Process(curproblem))
	{
	    TLProblemList branches(10, 10);

	    if (!GenerateBranches(curproblem, branches))
	    {
		// No further expansion possible --> we have a solution

		CreateSolution(curproblem);

		// If we return true, the search process stops; otherwise it
		// moves on to search for the next solution. Therefore, we
		// return true only if we have found all desired solutions.

	        if (SolutionCount() >= GetStats().mMaxSol)
		    return true;
	    }
	    else if (!mTerminate && StepForward(branches))
		return true;

	    // TODO: check if there is a memory leak in TLProblemList branches
	}
	LeaveState(curproblem);
    }
    return false;
}

/*-------------------------------------------------------------------------*/
    void TLBTSearcherRcsv::Terminate()

/*  Sets the termination flag, which causes the searcher to terminate as
    soon as possible.
---------------------------------------------------------------------------*/
{
    mTerminate = true;
}
