/****************************************************************************
    $Id: bincon.cpp 501.0 1995/03/07 12:26:08 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLBinCon. This class represents a binary
    constraint in the CSP framework.

    $Log: bincon.cpp $
    Revision 501.0  1995/03/07 12:26:08  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:04  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:24  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:36:19  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/10  16:45:47  ron
    Changed to <tlx\solve\csp.h>

    Revision 1.4  1994/09/28  14:13:29  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:22:01  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:39:20  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:12:54  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

//----- Project headers

#include <tlx\501\solve\csp.h>
#include <tlx\501\except.h>

/*-------------------------------------------------------------------------*/
    TLBinCon::TLBinCon(TLVariable &v1, TLVariable &v2)

/*  Constructor accepting references to the two variables that are involved
    in the constraint. The references are stored, but they are not yet
    watched by the constraint.
---------------------------------------------------------------------------*/
: mVar1(v1), mVar2(v2)
{
}

/*-------------------------------------------------------------------------*/
    TLVariable &TLBinCon::OppositeOf(TLVariable &aVar)

/*  Returns the opposite of the given variable.
---------------------------------------------------------------------------*/
{
    TLVariable *var = &aVar;

    if (&aVar == &mVar1)
	var = &mVar2;
    else if (&aVar == &mVar2)
	var = &mVar1;
    else
	THROW(TLXNotFound(LOCUS));

    return *var;
}

/*-------------------------------------------------------------------------*/
    const TLVariable &TLBinCon::OppositeOf(const TLVariable &aVar) const

/*  Returns the opposite of the given variable.
---------------------------------------------------------------------------*/
{
    const TLVariable *var = &aVar;

    if (&aVar == &mVar1)
	var = &mVar2;
    else if (&aVar == &mVar2)
	var = &mVar1;
    else
	THROW(TLXNotFound(LOCUS));

    return *var;
}

/*-------------------------------------------------------------------------*/
    void TLBinCon::UnwatchVars()

/*  Removes watches from both variables, i.e. removes the current constraint
    from the list of dependent constraints of both variables involved.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(mVar1.Constraints().Contains(this));
    TLX_ASSERT(mVar2.Constraints().Contains(this));

    mVar1.RemoveConstraint(this);
    mVar2.RemoveConstraint(this);
}

/*-------------------------------------------------------------------------*/
    void TLBinCon::WatchVars()

/*  Sets watches on both variables, i.e. adds the current constraint to
    the list of dependent constraints of both variables involved.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(!mVar1.Constraints().Contains(this));
    TLX_ASSERT(!mVar2.Constraints().Contains(this));

    mVar1.AddConstraint(this);
    mVar2.AddConstraint(this);
}

