/****************************************************************************
    $Id: bbstats.cpp 501.0 1995/03/07 12:26:08 RON Exp $

    Copyright (c) 1995 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal
    Created:    18-01-95 09:41

    Implementation of class TLBBStats.

    $Log: bbstats.cpp $
    Revision 501.0  1995/03/07 12:26:08  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/18 10:37:20  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1995/01/18  10:37:20  ron
    Initial revision
    
****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

#include <iostream.h>
#include <iomanip.h>

#include <tlx\501\solve\searcher.h>

// Template source code

#include <tlx\501\template\array.cpp>
#include <tlx\501\template\stats1.cpp>

/*-------------------------------------------------------------------------*/
    TLBBStats::TLBBStats()

/*  Constructor.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    int TLBBStats::DefaultEvents() const

/*  Returns the set of search events that the monitor is interested in.
---------------------------------------------------------------------------*/
{
    return TLSearcher::sePreProcess | TLSearcher::seProcess;
}

/*-------------------------------------------------------------------------*/
    void TLBBStats::OnSearchEvent(
        TLSearcher *    aSearcher,
        const Event &   aEvent)

/*  Call-back for events handled by this monitor. It updates lowerbound
    statistics.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aSearcher);

    switch (aEvent.mCode)
    {
        case TLSearcher::sePreProcess:
        {
            // The preprocess event is used to reset the statistics
            // to resize the level branching array.

            mLBounds.Clear();
            TLX_ASSERT_PTR(aSearcher->GetProblemRep());
            mLBDepth.SetLimits(0, aSearcher->GetProblemRep()->Size());
            break;
        }
        case TLSearcher::seProcess:
        {
            // Whenever a problem is processed, its lowerbound is noted to
            // obtain a measure of the lowerbound progress during the process.

            int depth = aSearcher->GetLevel();
            TLX_ASSERT(depth >= mLBDepth.Mini());
            TLX_ASSERT(depth <= mLBDepth.Maxi());

            TLX_ASSERT_PTR(aEvent.mProblem);
            TLBBInfo *info = DYNACAST(TLBBInfo *,
                                aEvent.mProblem->GetInfo());
            TLX_ASSERT_PTR(info);

            double lb = info->LowerBound();
            mLBounds.Add(lb);
            mLBDepth[depth].Add(lb);

            break;
        }
        // default: all others are ignored
    }
}

/*-------------------------------------------------------------------------*/
    ostream &TLBBStats::PrintOn(ostream &os) const

/*  Function to print the contents of the monitor on the given stream,
    usually as part of the searcher's ReportStats() processing.
---------------------------------------------------------------------------*/
{
    os << "Overall lowerbounds: " << mLBounds << "\n";
    os << "Per-level lowerbounds for " << mLBDepth.Size() << " levels:\n";

    for (index_t i = mLBDepth.Mini(); i <= mLBDepth.Maxi(); i++)
        os << setw(4) << i << " - " << mLBDepth[i] << "\n";

    return os;
}

