/****************************************************************************
    $Id: batchapp.cpp 501.0 1995/03/07 12:26:06 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLBatchApp.

    $Log: batchapp.cpp $
    Revision 501.0  1995/03/07 12:26:06  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:30:02  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/06  15:57:23  ron
    Corrected Revision keyword

    Revision 1.6  1994/11/16  15:35:57  ron
    Added module info; rearranged #include directives

    Revision 1.5  1994/10/05  18:33:32  ron
    Renamed TLx...() functions to tl...()

    Revision 1.4  1994/09/28  14:12:37  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:21:56  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:38:36  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:12:52  ron
    Initial revision

****************************************************************************/

#include <tlx\501\_build.h>

TLX_MODULE_INFO("$Revision: 501.0 $");

//----- System headers

#ifdef _TLXDBG
#include <iostream.h>
#endif

//----- Project headers

#include <tlx\501\cmdapp.h>

/*-------------------------------------------------------------------------*/
    TLBatchApp::TLBatchApp(int argc, char *argv[], const char *ver)

/*  Initializes the application from main()'s command line arguments.
---------------------------------------------------------------------------*/
: mArgCnt(argc), mArgs(argv), mVersion(ver)
{
    mCurArg  = 1;		// Skip program name
    mDone    =
    mRetCode = 0;
}

/*-------------------------------------------------------------------------*/
    TLBatchApp::~TLBatchApp()

/*  Destructor. Declared virtual for derivation.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::Abort(int ret)

/*  Called when the application must exit prematurely and without
    postprocessing.
---------------------------------------------------------------------------*/
{
    mDone = -1;		// Negative value indicates quick exit
    mRetCode = ret;
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::DoFile(const char *fname)

/*  Called to handle the next file on the command line. The debugging
    version of the default implementation simply prints the file name
    on cout.
---------------------------------------------------------------------------*/
{
#ifdef NDEBUG
    (void)fname;
#else
    cout << "\tFile\t= " << fname << "\n";
#endif
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::DoOption(const char *opt)

/*  Called to handle the next option on the command line. The debugging
    version of the default implementation simply prints the option on cout.
---------------------------------------------------------------------------*/
{
#ifdef NDEBUG
    (void)opt;
#else
    cout << "\tOption\t= " << opt << "\n";
#endif
}

/*-------------------------------------------------------------------------*/
    bool TLBatchApp::PostProcess()

/*  Optional postprocessing, should return nonzero on success.
---------------------------------------------------------------------------*/
{
    return true;
}

/*-------------------------------------------------------------------------*/
    bool TLBatchApp::PreProcess()

/*  Optional preprocessing, should return nonzero on success.
---------------------------------------------------------------------------*/
{
    return true;
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::PrintLogo()

/*  Called to print the log-on message for the application.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::PrintSyntax()

/*  Called to print a syntax summary for the command in case of an error.
---------------------------------------------------------------------------*/
{
}

/*-------------------------------------------------------------------------*/
    int TLBatchApp::Run()

/*  The main routine. This function contains calls to preprocessing and
    postprocessing functions and the main loop.
---------------------------------------------------------------------------*/
{
    PrintLogo();			// Make ourselves known

    if (!PreProcess()) return -1;	// Terminate early

    // Start the main loop, dealing with options and filenames as they
    // come along. Note that there is no objection against other routines
    // manipulating the '_args' sequence as well, in particular if they
    // need to advance its internal iterator.

    mDone   = mRetCode = 0;
    mCurArg = 1;

    while (!mDone && mArgs[mCurArg])
    {
	if (tlIsOption(mArgs[mCurArg]))
	    DoOption(mArgs[mCurArg]);
	else
	    DoFile(mArgs[mCurArg]);

	++mCurArg;		    // Advance iterator
    }

    // If the main loop finished because of premature termination through
    // terminate(), mDone will be < 0 and we don't want any postprocessing.

    if (mDone >= 0) PostProcess();

    return mRetCode;
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::SetRetCode(int ret)

/*  Sets the return code for the application without terminating it in
    any way.
---------------------------------------------------------------------------*/
{
    mRetCode = ret;
}

/*-------------------------------------------------------------------------*/
    void TLBatchApp::Terminate(int ret)

/*  Called when the application must exit prematurely, but in an orderly
    fashion, i.e. with postprocessing. It is not normally necessary to
    call this function, since the main loop will terminate when it has
    exhausted the program's arguments.
---------------------------------------------------------------------------*/
{
    mDone = 1;		// Positive value indicates graceful exit
    mRetCode = ret;
}

