/****************************************************************************
    $Id: rtti.h 501.0 1995/03/07 12:26:46 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations for RTTI-related matters. Basically, this file contains
    macros that allow use of RTTI-like expressions even if the compiler
    does not yet support it. In those cases, the expressions are turned
    into simple (static) casts etc.

    $Log: rtti.h $
    Revision 501.0  1995/03/07 12:26:46  RON
    Updated for TLX 5.01
    Revision 1.3  1995/01/31 16:29:24  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.2  1994/09/06  13:58:34  ron
    Added macros for all of the new-style C++ casts

    Revision 1.1  1994/08/16  18:06:51  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_RTTI_H
#define _TLX_RTTI_H

#ifdef _NORTTI		//-----	Compiler does not support RTTI

#define TYPEID(T)       # T

#define DYNACAST(T, v)	((T)(v))
#define CONSTCAST(T, v)	((T)(v))
#define STATCAST(T, v)	((T)(v))
#define RECAST(T, v)	((T)(v))

#else			//-----	Compiler supports RTTI

#define TYPEID(T)       typeid(T)

#define DYNACAST(T, v)	dynamic_cast<T>(v)
#define CONSTCAST(T, v)	const_cast<T>(v)
#define STATCAST(T, v)	static_cast<T>(v)
#define RECAST(T, v)	reinterpret_cast<T>(v)

#endif	// _NORTTI

#endif	// _TLX_RTTI_H
