/****************************************************************************
    $Id: ptrarray.inl 1.1 1994/09/26 15:27:48 ron Exp $

    Copyright (c) 1991-94 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Inline functions belonging to ptrarray.h. You should not #include this
    file directly.

    $Log: ptrarray.inl $
    Revision 1.1  1994/09/26  15:27:48  ron
    Initial revision
    
****************************************************************************/

//----- TLPtrVector

template<class T> inline
TLPtrVector<T> &TLPtrVector<T>::operator =(const TLPtrVector<T> &aVector)
    { return (TLPtrVector<T> &)TLVPVector::operator =(aVector); }

template<class T> inline TLPtrVector<T> &TLPtrVector<T>::operator =(T *aPtr)
    { return (TLPtrVector<T> &)TLVPVector::operator =(aPtr); }

template<class T> inline T *&TLPtrVector<T>::operator [](tIndex aIndex)
    { return (T *&)TLVPVector::operator [](aIndex); }

template<class T> inline T *TLPtrVector<T>::operator [](tIndex aIndex) const
    { return (T *)TLVPVector::operator [](aIndex); }

template<class T> inline T *&TLPtrVector<T>::PeekAt(tIndex aIndex)
    { return (T *&)TLVPVector::PeekAt(aIndex); }

template<class T> inline T *TLPtrVector<T>::PeekAt(tIndex aIndex) const
    { return (T *)TLVPVector::PeekAt(aIndex); }

template<class T> inline tIndex	TLPtrVector<T>::IndexOf(const T *aPtr) const
    { return TLVPVector::IndexOf(aPtr); }

template<class T> inline T **TLPtrVector<T>::StorageVector() const
    { return (T **)TLVPVector::StorageVector(); }

//-----	TLPtrArray

template<class T>
inline TLPtrArray<T> &TLPtrArray<T>::operator =(const TLPtrArray<T> &aArray)
    { return (TLPtrArray<T> &)TLVPArray::operator =(aArray); }

template<class T> inline TLPtrArray<T> &TLPtrArray<T>::operator =(T *aPtr)
    { return (TLPtrArray<T> &)TLVPArray::operator =(aPtr); }

template<class T> inline T *&TLPtrArray<T>::operator [](tIndex aIndex)
    { return (T *&)TLVPArray::operator [](aIndex); }

template<class T> inline T *TLPtrArray<T>::operator [](tIndex aIndex) const
    { return (T *)TLVPArray::operator [](aIndex); }

template<class T> inline T *&TLPtrArray<T>::PeekAt(tIndex aIndex)
    { return (T *&)TLVPArray::PeekAt(aIndex); }

template<class T> inline T *TLPtrArray<T>::PeekAt(tIndex aIndex) const
    { return (T *)TLVPArray::PeekAt(aIndex); }

template<class T> inline tIndex TLPtrArray<T>::IndexOf(const T *aPtr) const
    { return TLVPArray::IndexOf(aPtr); }

//-----	TLPtrSeq

template<class T>
inline TLPtrSeq<T> &TLPtrSeq<T>::operator =(const TLPtrSeq<T> &aSeq)
    { return (TLPtrSeq<T> &)TLVPSeq::operator =(aSeq); }

template<class T> inline TLPtrSeq<T> &TLPtrSeq<T>::operator =(T *aPtr)
    { return (TLPtrSeq<T> &)TLVPSeq::operator =(aPtr); }

template<class T>
inline TLPtrSeq<T> &TLPtrSeq<T>::operator +=(const TLPtrSeq<T> &aSeq)
    { return (TLPtrSeq<T> &)TLVPSeq::operator +=(aSeq); }

template<class T> inline TLPtrSeq<T> &TLPtrSeq<T>::operator +=(T *aPtr)
    { return (TLPtrSeq<T> &)TLVPSeq::operator +=(aPtr); }

template<class T> inline void TLPtrSeq<T>::Append(T *aPtr)
    { TLVPSeq::Append(aPtr); }

template<class T> inline void TLPtrSeq<T>::Append(T **aVector, tSize aSize)
    { TLVPSeq::Append((void **)aVector, aSize); }

template<class T> inline void TLPtrSeq<T>::Append(const TLPtrSeq<T> &aSeq)
    { TLVPSeq::Append(aSeq); }

template<class T> inline void TLPtrSeq<T>::Prepend(T *aPtr)
    { TLVPSeq::Prepend(aPtr); }

template<class T> inline void TLPtrSeq<T>::Prepend(T **aVector, tSize aSize)
    { TLVPSeq::Prepend((void **)aVector, aSize); }

template<class T> inline void TLPtrSeq<T>::Prepend(const TLPtrSeq<T> &aSeq)
    { TLVPSeq::Prepend(aSeq); }

template<class T> inline void TLPtrSeq<T>::Insert(T *aPtr)
    { TLVPSeq::Insert(aPtr); }

template<class T> inline void TLPtrSeq<T>::InsertAt(tIndex aIndex, T *aPtr)
    { TLVPSeq::InsertAt(aIndex, aPtr); }

template<class T>
inline void TLPtrSeq<T>::InsertAt(tIndex aIndex, T **aVector, tSize aSize)
    { TLVPSeq::InsertAt(aIndex, (void **)aVector, aSize); }

template<class T>
inline void TLPtrSeq<T>::InsertAt(tIndex aIndex, const TLPtrSeq<T> &aSeq)
    { TLVPSeq::InsertAt(aIndex, aSeq); }

template<class T> inline void TLPtrSeq<T>::Replace(tIndex aIndex, T *aPtr)
    { TLVPSeq::Replace(aIndex, aPtr); }

template<class T>
inline void TLPtrSeq<T>::Replace(tIndex aIndex, T **aVector, tSize aSize)
    { TLVPSeq::Replace(aIndex, (void **)aVector, aSize); }

template<class T>
inline void TLPtrSeq<T>::Replace(tIndex aIndex, const TLPtrSeq<T> &aSeq)
    { TLVPSeq::Replace(aIndex, aSeq); }

template<class T> inline T *TLPtrSeq<T>::Extract(T *p)
    { return (T *)TLVPSeq::Extract(p); }

template<class T> inline T *TLPtrSeq<T>::Extract(tIndex aIndex)
    { return (T *)TLVPSeq::Extract(aIndex); }

template<class T> inline T *TLPtrSeq<T>::ExtractFirst()
    { return (T *)TLVPSeq::ExtractFirst(); }

template<class T> inline T *TLPtrSeq<T>::ExtractLast()
    { return (T *)TLVPSeq::ExtractLast(); }

template<class T> inline T *&TLPtrSeq<T>::operator [](tIndex aIndex)
    { return (T *&)TLVPSeq::operator [](aIndex); }

template<class T> inline T *TLPtrSeq<T>::operator [](tIndex aIndex) const
    { return (T *)TLVPSeq::operator [](aIndex); }

template<class T> inline T *&TLPtrSeq<T>::PeekAt(tIndex aIndex)
    { return (T *&)TLVPSeq::PeekAt(aIndex); }

template<class T> inline T *TLPtrSeq<T>::PeekAt(tIndex aIndex) const
    { return (T *)TLVPSeq::PeekAt(aIndex); }

template<class T> inline T *&TLPtrSeq<T>::PeekReverse(tIndex aIndex)
    { return (T *&)TLVPSeq::PeekReverse(aIndex); }

template<class T> inline T *TLPtrSeq<T>::PeekReverse(tIndex aIndex) const
    { return (T *)TLVPSeq::PeekReverse(aIndex); }

template<class T> inline T *&TLPtrSeq<T>::PeekFirst()
    { return (T *&)TLVPSeq::PeekFirst(); }

template<class T> inline T *TLPtrSeq<T>::PeekFirst() const
    { return (T *)TLVPSeq::PeekFirst(); }

template<class T> inline T *&TLPtrSeq<T>::PeekLast()
    { return (T *&)TLVPSeq::PeekLast(); }

template<class T> inline T *TLPtrSeq<T>::PeekLast() const
    { return (T *)TLVPSeq::PeekLast(); }

template<class T> inline bool TLPtrSeq<T>::Contains(T *p) const
    { return TLVPSeq::Contains(p); }

template<class T> inline tIndex TLPtrSeq<T>::IndexOf(const T *aPtr) const
    { return TLVPSeq::IndexOf(aPtr); }

template<class T>
inline bool TLPtrSeq<T>::Search(const T *aPtr, tIndex &aIndex) const
    { return TLVPSeq::Search(aPtr, aIndex); }

//-----	TLPtrQueue

template<class T>
inline TLPtrQueue<T> &TLPtrQueue<T>::operator =(const TLPtrQueue<T> &q)
    { return (TLPtrQueue<T> &)TLVPQueue::operator =(q); }

template<class T> inline TLPtrQueue<T> &TLPtrQueue<T>::operator =(T *p)
    { return (TLPtrQueue<T> &)TLVPQueue::operator =(p); }

template<class T> inline void TLPtrQueue<T>::AddLeft(T *p)
    { TLVPQueue::AddLeft(p); }

template<class T> inline void TLPtrQueue<T>::AddRight(T *p)
    { TLVPQueue::AddRight(p); }

template<class T> inline T *TLPtrQueue<T>::ExtractLeft()
    { return (T *)TLVPQueue::ExtractLeft(); }

template<class T> inline T *TLPtrQueue<T>::ExtractRight()
    { return (T *)TLVPQueue::ExtractRight(); }

template<class T> inline T *&TLPtrQueue<T>::PeekLeft()
    { return (T *&)TLVPQueue::PeekLeft(); }

template<class T> inline T *TLPtrQueue<T>::PeekLeft() const
    { return (T *)TLVPQueue::PeekLeft(); }

template<class T> inline T *&TLPtrQueue<T>::PeekRight()
    { return (T *&)TLVPQueue::PeekRight(); }

template<class T> inline T *TLPtrQueue<T>::PeekRight() const
    { return (T *)TLVPQueue::PeekRight(); }

template<class T> inline void TLPtrQueue<T>::Enqueue(T *p)
    { TLVPQueue::Enqueue(p); }

template<class T> inline void TLPtrQueue<T>::EnqueueUnique(T *p)
    { TLVPQueue::EnqueueUnique(p); }

template<class T> inline T *TLPtrQueue<T>::Dequeue()
    { return (T *)TLVPQueue::Dequeue(); }

template<class T> inline T *&TLPtrQueue<T>::PeekHead()
    { return (T *&)TLVPQueue::PeekHead(); }

template<class T> inline T *TLPtrQueue<T>::PeekHead() const
    { return (T *)TLVPQueue::PeekHead(); }

template<class T> inline T *&TLPtrQueue<T>::PeekTail()
    { return (T *&)TLVPQueue::PeekTail(); }

template<class T> inline T *TLPtrQueue<T>::PeekTail() const
    { return (T *)TLVPQueue::PeekTail(); }

template<class T> inline bool TLPtrQueue<T>::Contains(T *p) const
    { return TLVPQueue::Contains(p); }

template<class T> inline T *TLPtrQueue<T>::Extract(T *p)
    { return (T *)TLVPQueue::Extract(p); }

template<class T> inline void TLPtrQueue<T>::Remove(T *p)
    { TLVPQueue::Remove(p); }

//-----	TLPtrStack

template<class T>
inline TLPtrStack<T> &TLPtrStack<T>::operator =(const TLPtrStack<T> &s)
    { return (TLPtrStack<T> &)TLVPStack::operator =(s); }

template<class T> inline TLPtrStack<T> &TLPtrStack<T>::operator =(T *p)
    { return (TLPtrStack<T> &)TLVPStack::operator =(p); }

template<class T> inline void TLPtrStack<T>::Push(T *p)
    { TLVPStack::Push(p); }

template<class T> inline void TLPtrStack<T>::Push(T **v, tSize sz)
    { TLVPStack::Push((void **)v, sz); }

template<class T> inline T *TLPtrStack<T>::Pop()
    { return (T *)TLVPStack::Pop(); }

template<class T> inline T *TLPtrStack<T>::Pop(T *p)
    { return (T *)TLVPStack::Pop(p); }

template<class T> inline void TLPtrStack<T>::Remove(T *p)
    { TLVPStack::Remove(p); }

template<class T> inline T *&TLPtrStack<T>::PeekTop()
    { return (T *&)TLVPStack::PeekTop(); }

template<class T> inline T *TLPtrStack<T>::PeekTop() const
    { return (T *)TLVPStack::PeekTop(); }

template<class T> inline bool TLPtrStack<T>::Contains(T *p)
    { return TLVPStack::Contains(p); }

//-----	TLPtrSet

template<class T>
inline TLPtrSet<T> &TLPtrSet<T>::operator =(const TLPtrSet<T> &aSet)
    { return (TLPtrSet<T> &)TLVPSet::operator =(aSet); }

template<class T> inline TLPtrSet<T> &TLPtrSet<T>::operator =(T *aPtr)
    { return (TLPtrSet<T> &)TLVPSet::operator =(aPtr); }

template<class T>
inline TLPtrSet<T> &TLPtrSet<T>::operator +=(const TLPtrSet<T> &aSet)
    { return (TLPtrSet<T> &)TLVPSet::operator +=(aSet); }

template<class T> inline TLPtrSet<T> &TLPtrSet<T>::operator +=(T *aPtr)
    { return (TLPtrSet<T> &)TLVPSet::operator +=(aPtr); }

template<class T> inline void TLPtrSet<T>::Insert(T *aPtr)
    { TLVPSet::Insert(aPtr); }

template<class T> inline T *  TLPtrSet<T>::Extract(T *aPtr)
    { return (T *)TLVPSet::Extract(aPtr); }

template<class T> inline void TLPtrSet<T>::Remove(T *aPtr)
    { TLVPSet::Remove(aPtr); }

template<class T> inline bool TLPtrSet<T>::Contains(const T *aPtr) const
    { return TLVPSet::Contains(aPtr); }

template<class T> inline T *&TLPtrSet<T>::PeekAt(tIndex i)
    { return (T *&)TLVPSet::PeekAt(i); }

template<class T> inline T *TLPtrSet<T>::PeekAt(tIndex i) const
    { return (T *)TLVPSet::PeekAt(i); }

