/****************************************************************************
    $Id: netbios.h 501.0 1995/03/07 12:26:52 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Declarations for NetBIOS network protocol functions.

    $Log: netbios.h $
    Revision 501.0  1995/03/07 12:26:52  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:29:02  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1995/01/05  15:36:13  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_NETBIOS_H
#define _TLX_NETBIOS_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

// Compile only if DOS or Windows

#if OS_DOSXXX || OS_WINXXX

// Make sure that all items are packed correctly

#if defined(__TURBOC__)
    #pragma option -a-
#elif defined(_MSC_VER) || defined(__WATCOMC__)
#pragma pack(push, 1)
#elif defined(__IBMC__) || defined(__IBMCPP__)
    #pragma CompactStorage(1)
#elif defined(__ZTC__)
    #pragma align 1
#else
    #error Unsupported compiler
#endif

/*---------------------------------------------------------------------------
    Auxiliary definitions:

    - NetBIOS error messages
    - NetBIOS command ID's
    - various types and parameters
---------------------------------------------------------------------------*/

// NetBIOS error return messages

extern char *           gNetBIOSMessage[];

// Symbolic names for NetBIOS error codes

#define NB_ERR_BADCOMMAND               0x03
#define NB_ERR_TIMEDOUT                 0x05
#define NB_ERR_BADADAPTER               0x23
#define NB_ERR_INPROGRESS               0xFF

// Symbolic names for NetBIOS commands

#define NB_NOWAIT                       0x80

#define NB_RESET                        0x32
#define NB_CANCEL                       0x35
#define NB_STATUS                       0x33
#define NB_TRACE                        0x79
#define NB_UNLINK                       0x70
#define NB_ADDNAME                      0x30
#define NB_ADDGROUP                     0x36
#define NB_DELETENAME                   0x31
#define NB_CALL                         0x10
#define NB_LISTEN                       0x11
#define NB_HANGUP                       0x12
#define NB_SEND                         0x14
#define NB_SENDNOACK                    0x71
#define NB_CHAINSEND                    0x17
#define NB_CHAINSENDNOACK               0x72
#define NB_RECEIVE                      0x15
#define NB_RECEIVEANY                   0x16
#define NB_SESSIONSTATUS                0x34
#define NB_SENDDATAGRAM                 0x20
#define NB_SENDBROADCAST                0x22
#define NB_RECEIVEDATAGRAM              0x21
#define NB_RECEIVEBROADCAST             0x23

#define NB_NAMELEN      16              // Includes terminating '\0'

typedef void _Far *callback_f;

/*---------------------------------------------------------------------------
    TLNCB -

    NetBIOS Network Control Block, used for all NetBIOS commands.
---------------------------------------------------------------------------*/

typedef struct TLNCB
{
    uint8               mCommand;       /* Command code */
    uint8               mResult;        /* Immediate return code */
    uint8               mLSN;           /* Local Session Number */
    uint8               mNameNo;        /* Name number */
    void _Far * mBuffer;        /* Pointer to data buffer */
    uint16              mSize;          /* Size of the data buffer */
    char                mRemoteName[16];/* Name of the remote station */
    char                mLocalName[16]; /* Name of the local station */
    uint8               mRcvTimeOut;    /* Receive time-out */
    uint8               mSndTimeOut;    /* Send time-out */
    callback_f          mCallBack;      /* TLCountedPtr to call-back function */
    uint8               mAdapter;       /* Adapter number */
    uint8               mCompletion;    /* Final completion code */
    uint8               mReserved[14];
} TLNCB;

/*---------------------------------------------------------------------------
    TLAdapterStatus -

    NetBIOS adapter status information block, filled by NBAdapterStatus().
---------------------------------------------------------------------------*/

typedef struct TLAdapterStatus
{
    uint8               mCardID[6];     /* Card identification */
    uint8               mLevel;         /* Release level */
    uint8               mReserved1;
    uint8               mType;          /* Adapter type */
    uint8               mOldNewFlag;    /* Old or new parameters */
    uint16              mReportPeriod;
    uint16              mRcvRejects;    /* # rejected receive frames */
    uint16              mSndRejects;    /* # rejected send frames */
    uint16              mRcvFrameErrors;/* # receive frame errors */
    uint16              mSndErrors;     /* # send errors */
    uint32              mSndCount;      /* # successful sends */
    uint32              mRcvCount;      /* # successful receives */
    uint16              mRetransCount;  /* # retransmissions */
    uint16              mExhaustCount;  /* # exhausted resources */
    uint16              mT1Expirations; /* # T1 timer expirations */
    uint16              mT2Expirations; /* # T2 timer expirations */
    uint8               mReserved2[4];
    uint16              mNCBAvailable;  /* # available NCBs */
    uint16              mNCBConfig;     /* Maximum configured # NCBs */
    uint16              mNCBPossible;   /* Maximum possible # NCBs */
    uint16              mBusyCount;
    uint16              mMaxDataSize;   /* Maximum datagram size */
    uint16              mSesPending;    /* # pending sessions */
    uint16              mSesConfig;     /* Maximum configured # sessions */
    uint16              mSesPossible;   /* Maximum possible # sessions */
    uint16              mMaxFrameSize;  /* Maximum frame size */
    int16               mNameCount;     /* Number of valid names in table */
    struct
    {
        char            mTblName[16];   /* Name in the table */
        uint8           mTblNumber;     /* Associated name number */
        uint8           mTblStatus;     /* Associated name status */
    }                   mNameTable[20]; /* Table of known names */
} TLAdapterStatus;

/*---------------------------------------------------------------------------
    NetBIOS functions
---------------------------------------------------------------------------*/

bool    _TLXFUNC NBInstalled(void);
uint16  _TLXFUNC NBExecute(TLNCB _Far *);
uint16  _TLXFUNC NBCancel(TLNCB _Far *);
uint16  _TLXFUNC NBReset(uint8 maxSes, uint8 maxNCB, uint8 adapt);
uint16  _TLXFUNC NBAdapterStatus(const char *, TLAdapterStatus _Far *);
uint16  _TLXFUNC NBAddNameNW(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBAddName(const char *, uint8 *);
uint16  _TLXFUNC NBAddGroupNW(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBAddGroup(const char *, uint8 *);
uint16  _TLXFUNC NBDeleteNameNW(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBDeleteName(const char *);
uint16  _TLXFUNC NBSendDatagram(TLNCB _Far *);
uint16  _TLXFUNC NBSendDatagramNW(TLNCB _Far *);

// Auxiliary functions

char *  _TLXFUNC NBGetName(char *, const char *);
char *  _TLXFUNC NBSetName(char *, const char *);
char *  _TLXFUNC NBGetLocalName(TLNCB _Far *, char *);
char *  _TLXFUNC NBGetRemoteName(TLNCB _Far *, char *);
void    _TLXFUNC NBSetLocalName(TLNCB _Far *, const char *);
void    _TLXFUNC NBSetRemoteName(TLNCB _Far *, const char *);

void            _TLXFUNC NBClearNCB(TLNCB _Far *);
const char *    _TLXFUNC NBErrorMsg(uint16);

/*
uint16  _TLXFUNC NBPostAddName(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBPostAddGroup(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBPostDeleteName(TLNCB _Far *, const char *, callback_f);
uint16  _TLXFUNC NBExecAddName(TLNCB _Far *, const char *, uint8 *);
uint16  _TLXFUNC NBExecAddGroup(TLNCB _Far *, const char *, uint8 *);
uint16  _TLXFUNC NBExecDeleteName(TLNCB _Far *, const char *);
*/

#if defined(__TURBOC__)
    #pragma option -a.
#elif defined(_MSC_VER) || defined(__WATCOMC__)
#pragma pack(pop)
#elif defined(__IBMC__) || defined(__IBMCPP__)
    #pragma CompactStorage()
#elif defined(__ZTC__)
    /*#pragma align 1*/
#else
    #error Unsupported compiler
#endif

#endif  // OS_DOSXXX || OS_WINXXX
#endif  // _TLX_NETBIOS_H
