/****************************************************************************
    $Id: microsof.h 501.0 1995/03/07 12:26:44 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Microsoft-specific declarations of compilation and keyword-like names.

    $Log: microsof.h $
    Revision 501.0  1995/03/07 12:26:44  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:32:12  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/11/16  15:22:38  ron
    Added _CCNAME, _CCVER, and _MODEL definitions

    Revision 1.3  1994/10/06  17:48:36  ron
    Added _NOMUTABLE

    Revision 1.2  1994/09/08  15:53:59  ron
    Moved O/S-specific macros into this file

    Revision 1.1  1994/08/16  18:06:49  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_MICROSOF_H
#define _TLX_MICROSOF_H

#ifndef _MSC_VER
#error This file is for Microsoft compilations only
#endif

#define _CCNAME		Microsoft C++
#define _CCVER		_MSC_VER

#ifdef _DLL
    #define _IN_DLL     1
#endif

#if _MSC_VER < 1000
#error TLX 5.0 requires C++ template support
#define _NORTTI		1
#define _NOEXCEPT	1
#define _NOBOOL		1
#define _NOMUTABLE	1
#elif _MSC_VER < 1020
#define _NOBOOL		1
#define _NOMUTABLE	1
#pragma warning(disable:4237)	/* Non-standard 'bool' etc. extension */
#else
#define _NOMUTABLE	1
#pragma warning(disable:4237)	/* Non-standard 'bool' etc. extension */
#endif

#ifdef _WIN32			/* Non-segmented platforms */

    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat

    #define _ExportClass        __export
    #define _ExportFunc         __export
    #define _ExportData         __export

    #define _ImportClass	__import
    #define _ImportFunc		__import
    #define _ImportData		__import

#else                           /* Segmented memory architectures */

    #define _Near               _near
    #define _Far                _far
    #define _Huge               _huge

    #define _ExportClass        __export
    #define _ExportFunc         __export __far
    #define _ExportData         __export __far

    #define _ImportClass        __huge
    #define _ImportFunc         __far
    #define _ImportData         __far

    #if defined(M_I86TM) || defined(M_I86SM)
        #define _CODE_NEAR      1
        #define _DATA_NEAR      1
    	#define _MODEL		Tiny/Small
    #elif defined(M_I86CM)
        #define _CODE_NEAR      1
        #define _DATA_FAR       1
    	#define _MODEL		Compact
    #elif defined(M_I86MM)
        #define _DATA_NEAR      1
        #define _CODE_FAR       1
    	#define _MODEL		Medium
    #elif defined(M_I86LM) || defined(M_I86HM)
        #define _CODE_FAR       1
        #define _DATA_FAR       1
    	#define _MODEL		Flat
    #else
        #error Unknown Microsoft memory model
    #endif
#endif

#if defined(_WIN32)
    #define OS_WIN32    1
    #define OS_WINXXX   1
    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1
#elif defined(_WINDOWS)
    #define OS_WIN16    1
    #define OS_WINXXX   1
    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_SEG    1
#elif defined(_MSDOS)
    #define OS_DOS      1
    #define OS_DOSXXX   1
    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_SEG    1
#elif defined(_MACINTOSH)
    #define OS_MAC      1
    #define _CPU_M68    1               // Might be PowerPC!
    #define _BENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1
#else
    #error Unknown Microsoft compilation target
#endif

#if 0
/*---------------------------------------------------------------------------
    Microsoft C/C++ 7.0/8.0 additional functions
---------------------------------------------------------------------------*/

#ifndef _VA_LIST_DEFINED
typedef char *va_list;
#define _VA_LIST_DEFINED
#endif

int     _TLXFUNC vsscanf(const char *, const char *, va_list);
#endif

#endif  /* _TLX_MICROSOF_H */
