/****************************************************************************
    $Id: intset.h 501.0 1995/03/07 12:26:44 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Declaration of class TLIntSet, representing a set of integers.

    $Log: intset.h $
    Revision 501.0  1995/03/07 12:26:44  RON
    Updated for TLX 5.01
    Revision 1.4  1995/01/31 16:29:22  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.3  1994/10/05  18:21:47  ron
    Added output operator for TLIntSet

    Revision 1.2  1994/09/27  20:25:16  ron
    Changed path separator from / to \

    Revision 1.1  1994/09/26  15:18:12  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_INTSET_H
#define _TLX_INTSET_H

#ifndef _TLX_BITVECT_H
#include <tlx\501\bitvect.h>
#endif
#ifndef _TLX_ITER_H
#include <tlx\501\iter.h>
#endif

/*---------------------------------------------------------------------------
    TLIntSet -

    Set of integers with corresponding operations. The set has a fixed
    capacity, which cannot be expanded after creation.
---------------------------------------------------------------------------*/

class _TLXCLASS TLIntSet
{
public:
    // Iterator class to iterate through all elements of the set

    class _TLXCLASS Iter: public TLValueIterConst<int>
    {
        const TLIntSet &        mSet;   // Set being iterated
        int                     mPos;   // Iteration position within set

    public:
        Iter(const TLIntSet &);

        // Overridden iterator operations

        virtual const int &     Peek() const;
        virtual size_t          Count() const;

    private:
        virtual bool            FirstPos();
        virtual bool            NextPos();
        bool                    SearchFrom(int);
    };
    friend _TLXCLASS class Iter;

private:
    TLBitVector         mSet;           // The set representation
    int                 mBase;          // Base element

public:
    TLIntSet(size_t = 0);               // Capacity for [0, size>
    TLIntSet(int, int);                 // Capacity for [lower, upper]
    TLIntSet(int *, size_t);            // Capacity for assorted elements

    // General information about the set

    size_t              Count() const;
    bool                Contains(int) const;
    bool                IsEmpty() const;

    // Limits of the set:
    //
    // - LowerBound() and UpperBound() indicate capacity bounds
    // - First() and Last() return the current smallest and largest
    //   elements, respectively.

    int                 LowerBound() const;
    int                 UpperBound() const;
    int                 First() const;
    int                 Last() const;

    // Adding elements to the set

    void                Insert(int);
    void                Insert(int, int);
    void                Insert(int *, size_t);
    void                InsertAll();

    // Removing elements from the set

    void                Remove(int);
    void                Remove(int, int);
    void                Remove(int *, size_t);
    void                RemoveAll();

    // Output operator

    friend ostream &    _TLXFUNC operator <<(ostream &, const TLIntSet &);
};

/*---------------------------------------------------------------------------
    Inline functions
---------------------------------------------------------------------------*/

inline size_t TLIntSet::Iter::Count() const
    { return mSet.Count(); }

inline bool TLIntSet::IsEmpty() const
    { return Count() == 0; }

#endif // _TLX_INTSET_H
