/****************************************************************************
    $Id: genmacro.h 501.0 1995/03/07 12:26:42 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Preprocessor macros to imitate or enhance C++ templates. They are used
    in situations where the C++ template mechanism cannot be used, e.g.
    function templates with template arguments not appearing in the function
    header.

    $Log: genmacro.h $
    Revision 501.0  1995/03/07 12:26:42  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:29:20  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1994/08/16  18:06:47  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_GENMACRO_H
#define _TLX_GENMACRO_H

/*---------------------------------------------------------------------------
    Token pasting macros use an extra level to allow macros to appear as
    arguments in other macros if an ANSI-C compatible preprocessor is
    used. Usage:

    NAME2()		- concatenates 2 names (with argument expansion)
    NAME3()		- concatenates 3 names (with argument expansion)
    NAME4()		- concatenates 4 names (with argument expansion)

    DECLARE(X,Y)	- produces 'Xdeclare(Y)' (with argument expansion)
    DECLARE2(X,Y,Z)	- produces 'Xdeclare(Y,Z)' (with argument expansion)
    IMPLEMENT(X,Y)	- produces 'Ximplement(Y)' (with argument expansion)
    IMPLEMENT2(X,Y,Z)	- produces 'Ximplement(Y,Z)' (with argument expansion)
---------------------------------------------------------------------------*/

#define NAME2(a,b)		_P2(a,b)
#define NAME3(a,b,c)		_P3(a,b,c)
#define NAME4(a,b,c,d)		_P4(a,b,c,d)

#define _P2(a,b)		a ## b
#define _P3(a,b,c)		a ## b ## c
#define _P4(a,b,c,d)		a ## b ## c ## d

#define DECLARE(x,y)		NAME2(x,declare)(y)
#define DECLARE2(x,y,z)		NAME2(x,declare)(y,z)
#define IMPLEMENT(x,y)		NAME2(x,implement)(y)
#define IMPLEMENT2(x,y,z)	NAME2(x,implement)(y,z)

#endif	// _TLX_GENMACRO_H
