/****************************************************************************
    $Id: testable.h 501.0 1995/03/07 12:26:50 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations for testing functions and classes:

    TLTestable	- (virtual) base class for all testable classes

    $Log: testable.h $
    Revision 501.0  1995/03/07 12:26:50  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:29:00  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1995/01/05  15:36:00  ron
    Initial revision

    Revision 1.1  1994/10/05  18:25:06  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_TESTABLE_H
#define	_TLX_TESTABLE_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

/*---------------------------------------------------------------------------
    Macros to enable/disable testability
---------------------------------------------------------------------------*/

#ifdef NDEBUG		//-----	No testing

#define TESTABLE		public TLNull
#define TEST_INTERFACE(Class)

#else			//-----	Testing version

#define TESTABLE		public virtual TLTestable

#define TEST_INTERFACE(Class)	\
    virtual void        _TstSetState(const char *);	\
    virtual void        _TstResetState();               \
    virtual void        _TstReportState();              \
    virtual void        _TstCheckState();

#endif

/*---------------------------------------------------------------------------
    TLNull -

    Empty class, used as a substitute for TLTestable when its functions
    are disabled in a non-debugging build.
---------------------------------------------------------------------------*/

class _TLXCLASS TLNull {};

/*---------------------------------------------------------------------------
    TLTestable -

    (Virtual) base class for all testable classes. It contains a generic
    interface to allow access to built-in class tests. Use it as follows:

    class YourClass: public FirstBase,...,TESTABLE
    {
    private:
	TEST_INTERFACE(YourClass)
    };

---------------------------------------------------------------------------*/

class _TLXCLASS TLTestable {
public:
    virtual ~TLTestable();

    // Standard testing interface. These functions should be overridden as
    // appropriate for derived classes. For output, they should use the
    // TLX_TRACE macros.

    virtual void        _TstSetState(const char *);
    virtual void        _TstResetState();
    virtual void        _TstReportState();
    virtual void        _TstCheckState();
};

************* Alternative:

class Tester {
public:
    virtual void        _TstSetState(const char *);
    virtual void        _TstResetState();
    virtual void        _TstReportState();
    virtual void        _TstCheckState();
};

class Testable {
public:
    virtual Tester *	CreateTester() = 0;
};

This would move the actual testing code outside the CUT proper, just as
with iterators. Result: less impact on the class under test.

#endif	// _TLX_TESTABLE_H
