/****************************************************************************
    $Id: modinfo.h 501.0 1995/03/07 12:26:50 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations for class TLModuleInfo, a repository for module information.
    The file also contains some macros for conditional inclusion of the
    information; the includion is subject to the definition of the
    preprocessor name NMODINFO.

    TLX_IDENT(ver);

	- Inserts a module information instance with the given string as its
	  version information; filename and date/time are automatically added.

    TLX_MODULE_INFO(ver);

	- Inserts a module information instance with the given string as its
	  version information; filename and date/time are automatically added.

    TLX_MODULE

	- Resolves to the module information instance for the current module.

    $Log: modinfo.h $
    Revision 501.0  1995/03/07 12:26:50  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:29:00  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1995/01/05  15:35:56  ron
    Initial revision

    Revision 1.1  1994/11/16  15:26:00  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_MODINFO_H
#define _TLX_MODINFO_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

#ifdef NMODINFO
/*---------------------------------------------------------------------------
    No module info - code vanishes
---------------------------------------------------------------------------*/

#define TLX_IDENT(ver)
#define TLX_MODULE_INFO(ver)
#define TLX_MODULE		TLModuleInfo::sNullInfo

#else
/*---------------------------------------------------------------------------
    Module info included
---------------------------------------------------------------------------*/

#define TLX_IDENT(ver)		static TLModuleInfo _gModInfo( \
				__FILE__, ver, __DATE__ " " __TIME__)
#define TLX_MODULE_INFO(ver)	static TLModuleInfo _gModInfo( \
				__FILE__, ver, __DATE__ " " __TIME__)
#define TLX_MODULE		_gModInfo

#endif	// NMODINFO

/*---------------------------------------------------------------------------
    TLModuleInfo -

    Repository for module information: filename, version, compilation date
    and time. All module info instances in a program are automatically
    linked into a single chain.
---------------------------------------------------------------------------*/

class _TLXCLASS TLModuleInfo
{
    // All instances of TLModuleInfo are linked together in a single chain.

  #ifdef _TLXDBG
    static int32	sModCount;	// Number of modules
  #endif
    static TLModuleInfo *sChain;	// Head of the chain
    TLModuleInfo *	mNext;		// Link field

    // Information about the module is all text

    const char *	mFilename;	// File name of the module
    const char *	mVersion;	// Version identification
    const char *	mDateTime;	// Date/time of the module build

public:
    // Constructor adds the instance to the global chain; destructor
    // removes it.

    TLModuleInfo(const char *, const char *, const char *);
    ~TLModuleInfo();

    // Access to individual pieces of information

    const char *	Filename() const;
    const char *	Version() const;
    const char *	DateTime() const;

    // Functions to report the information of a single module, and to
    // report information about all modules.

    ostream &		PrintOn(ostream &) const;
    static void		PrintAll(ostream &);

    // Single module information instance to stand in as null reference
    static TLModuleInfo sNullInfo;
};

/*---------------------------------------------------------------------------
    Inline definitions
---------------------------------------------------------------------------*/

#ifndef _TLXDBG
inline const char *TLModuleInfo::Filename() const
    { return mFilename; }

inline const char *TLModuleInfo::Version() const
    { return mVersion; }

inline const char *TLModuleInfo::DateTime() const
    { return mDateTime; }
#endif

#endif	// _TLX_MODINFO_H
