/****************************************************************************
    $Id: debug.h 501.0 1995/03/07 12:26:50 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Macros and auxiliary functions for debugging purposes. Normally, these
    macros are defined, but #defining NDEBUG prior to including this file
    will turn them into empty space or null statements, as appropriate.

    Debugging macros
    ----------------

    TLX_DEBUG_BREAK;

         - Inserts a debugger breakpoint.

    TLX_DEBUG_CODE( code )

	- Inserts 'code' as source code if debugging, else discards it.

    TLX_DEBUG_BLOCK { code }

	- Creates a source block (with its own private scope) if debugging,
	  else turns into a never-executed (and probably optimized away)
	  statement.

    Warning for Macintosh users:

        The code for the TLX_DEBUG_BREAK macro (if defined) executes the
        Macintosh Toolbox Debugger() trap. If no debugger is running at
        the time the trap is executed, a system error (ID = -12) will
        occur and the system must be restarted. Therefore, be sure to
        use TLX_DEBUG_BREAK only if you are running the program with a
	debugger or have MacsBug or another resident debugger installed.

        If NDEBUG is #defined, TLX_DEBUG_BREAK does not generate any code
	and may be used safely with any system configuration.

        There seems to be no reliable way to check whether the debugger
        trap is implemented; the TrapAvailable() function fails to find
        the trap installed when the THINK C/C++ debugger is running,
        although that debugger will catch the trap if it is executed.

    $Log: debug.h $
    Revision 501.0  1995/03/07 12:26:50  RON
    Updated for TLX 5.01
    Revision 1.2  1995/02/28 15:18:16  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1995/01/05  15:35:52  ron
    Initial revision

    Revision 1.1  1994/11/16  15:25:52  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_DEBUG_H
#define _TLX_DEBUG_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

#ifdef NDEBUG
/*---------------------------------------------------------------------------
    Debugging macros when not debugging - resolve to null code
---------------------------------------------------------------------------*/

#define TLX_DEBUG_CODE(x)
#define TLX_DEBUG_BLOCK		while (0)
#define TLX_DEBUG_BREAK		((void)0)

#else
/*---------------------------------------------------------------------------
    Debugging macros when debugging - resolve to actual code
---------------------------------------------------------------------------*/

#define TLX_DEBUG_CODE(x)	x
#define TLX_DEBUG_BLOCK

#if _CPU_I86
  #if defined(__IBMCPP__)
    #ifndef __builtin_h
    #include <builtin.h>
    #endif
    #define _tlBreak() _interrupt(3)
  #elif defined(__TURBOC__)
    #define _tlBreak() __emit__((byte_t)0xCC)
  #elif defined(__WATCOMC__)
    extern void _tlBreak(void);
    #pragma aux _tlBreak = "int 3"
  #elif defined(__ZTC__) && __ZTC__ < 0x700
    #define _tlBreak() asm((byte_t)0xCC)
  #else
    #define _tlBreak() do { _asm { int 3 } } while(0)
  #endif
#elif OS_MAC
    inline void _tlBreak() { Debugger(); }
#elif _CPU_SPARC
    #define _tlBreak()		// Leave undefined for now
#else
    #error Unsupported CPU type; contact Tarma Software Research
#endif

#define TLX_DEBUG_BREAK      	_tlBreak()

#endif  // NDEBUG

#endif	// _TLX_DEBUG_H
