/****************************************************************************
    $Id: compiler.h 501.0 1995/03/07 12:26:40 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Sample header for compiler description.

    $Log: compiler.h $
    Revision 501.0  1995/03/07 12:26:40  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:32:10  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1994/11/16  15:20:30  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_COMPILER_H
#define _TLX_COMPILER_H

#error This file is a sample only; contact Tarma Software Research

/*---------------------------------------------------------------------------
    Instructions
    ------------

    This file contains sections for all areas that are compiler-specific.
    If you encounter a compiler that isn't supported in the standard TLX
    distribution, you can use this file as a template from which to derive
    your own compiler description.
---------------------------------------------------------------------------*/

#define _CCNAME		Generic C++ compiler
#define _CCVER		0x0000

// If the compiler supports compilation of DLLs (or shared libraries in
// UNIX parlance), modify the following construct such that _IN_DLL is
// #defined to 1 if the compiler is set up for DLL compilation.

#ifdef _DLL
#define _IN_DLL     	1
#endif

// If there are special keywords used for classes in the compiler's runtime
// library, #define the following:

#define _RTLCLASS		// Used as 'class _RTLCLASS iostream;'

// The following set of preprocessor names is used to allow transition to
// the latest ANSI/ISO C++ standards. If your compiler does *not* a particular
// feature, #define the appropriate name to 1.
//
// Note: it is assumed that the compiler supports at least templates and
// multiple inheritance, i.e. the cfront 2.1 level.

#define _NORTTI		1	// Runtime type information supported?
#define _NOEXCEPT	1	// Exception handling supported?
#define _NOBOOL		1	// 'bool' data type supported?
#define _NOMUTABLE	1	// 'mutable' modifier supported?

// The largest set of options concerns memory models and related keywords.
// The first distinction is between flat and segmented memory architectures.
// #define *one* of the following:

#define _MEM_SEG	1	// If a segmented architecture
#define _MEM_FLAT	1	// If a non-segmented architecture

// To cope with segmented platforms, #define the following pseudo-keywords
// as appropriate. Also, specify the kind of default data and code pointers
// for the model.
//
// The directives for imported and exported data, functions, and classes
// are also usually architecture-related, so provide them as well.

#ifdef _MEM_SEG
    #define _Near	__near	// Modifier for explicit 'near' pointers
    #define _Far	__far	// Modifier for explicit 'far' pointers
    #define _Huge	__huge	// Modifier for explicit 'huge' pointers

    #define _ExportClass        __export __far
    #define _ExportFunc         __export __far
    #define _ExportData         __export __far

    #define _ImportClass        __huge
    #define _ImportFunc         __far
    #define _ImportData         __far

    #if defined(__TINY__)
        #define _CODE_NEAR      1
        #define _DATA_NEAR      1
    	#define _MODEL		Tiny
    #elif defined(__SMALL__)
        #define _CODE_NEAR      1
        #define _DATA_NEAR      1
    	#define _MODEL		Small
    #elif defined(__COMPACT__)
        #define _CODE_NEAR      1
        #define _DATA_FAR       1
    	#define _MODEL		Compact
    #elif defined(__MEDIUM__)
        #define _DATA_NEAR      1
        #define _CODE_FAR       1
    	#define _MODEL		Medium
    #elif defined(__LARGE__)
        #define _CODE_FAR       1
        #define _DATA_FAR       1
    	#define _MODEL		Large
    #elif defined(__HUGE__)
        #define _CODE_FAR       1
        #define _DATA_FAR       1
    	#define _MODEL		Huge
    #else
        #error Unknown memory model
    #endif

#else	// Assume non-segmented

    #define _Near
    #define _Far
    #define _Huge

    #define _MODEL	Flat	// Describes the model to TLX (only)

    #define _ExportClass        __export
    #define _ExportFunc         __export
    #define _ExportData         __export

    #define _ImportClass	__import
    #define _ImportFunc		__import
    #define _ImportData		__import
#endif

// Describe the target platform by defining one or more of the following:

#define OS_BSD      	1	// BSD Unix platform
#define OS_SCO      	1	// SCO Unix platform
#define OS_SV4      	1	// Unix SVR4.2 platform
#if OS_BSD || OS_SCO || OS_SV4
#define OS_UNIX      	1	// defined on all Unix platforms
#endif

#define OS_DOS      	1	// 16-bit real mode DOS platform
#define OS_DOS286   	1	// 16-bit protected mode DOS platform
#define OS_DOS386   	1	// 32-bit protected mode DOS platform
#if OS_DOS || OS_DOS286 || OS_DOS386
#define OS_DOSXXX	1	// defined on all DOS platforms
#endif

#define OS_MAC      	1	// Macintosh 6.x and above platforms
#define OS_OS2      	1	// OS/2 2.x platforms

#define OS_WIN16    	1	// 16-bit Windows platforms
#define OS_WIN32    	1	// 32-bit Windows platforms
#define OS_WIN32S   	1	// 32-bit subset Windows platforms
#if OS_WIN16 || OS_WIN32 || OS_WIN32S
#define OS_WINXXX	1	// defined on all Windows platforms
#endif

// Target CPU (#define *one* of the following)

#define _CPU_I86    	1	// On Intel i86 platforms
#define _CPU_M68    	1       // On Motorola 680x0 platforms
#define _CPU_ALPHA   	1	// On DEC Alpha platforms
#define _CPU_MIPS    	1	// On MIPS platforms
#define _CPU_PPC     	1	// On Motorola/IBM PowerPC platforms
#define _CPU_SPARC   	1	// On Sparc platforms

// Describe endianity (there are no provisions for mixed-endianity)
// by #defining *one* of the following:

#define _LENDIAN    	1	// Little endian (LSB at lowest address)
#define _BENDIAN    	1	// Big endian (LSB at highest address)

// If a NULL pointer is represented as an all-0 bit pattern, define this:

#define _NULL_IS_0  	1

#endif  // _TLX_COMPILER_H
