/****************************************************************************
    $Id: cmdapp.h 501.0 1995/03/07 12:26:40 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations for command line application classes and functions.

    $Log: cmdapp.h $
    Revision 501.0  1995/03/07 12:26:40  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:29:16  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/18  18:53:21  ron
    Added support for Windows NT

    Revision 1.6  1994/10/05  18:19:11  ron
    Renamed TLx...() functions to tl...()

    Revision 1.5  1994/09/28  14:25:16  ron
    Removed Macintosh-style #include references

    Revision 1.4  1994/09/27  20:24:56  ron
    Changed path separator from / to \

    Revision 1.3  1994/09/26  15:15:10  ron
    Changed OS_DOS check to OS_DOSXXX

    Revision 1.2  1994/09/06  14:00:06  ron
    Small change from OS_WIN to OS_WIN16 support

    Revision 1.1  1994/08/16  18:06:44  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_CMDAPP_H
#define _TLX_CMDAPP_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

/*---------------------------------------------------------------------------
    Declarations for general application attributes, such as command-line
    options.
---------------------------------------------------------------------------*/

#if OS_DOSXXX || OS_OS2 || OS_WINXXX
    const char		gOptionChar = '/';
#elif OS_MAC || OS_UNIX
    const char		gOptionChar = '-';
#else
    #error Unsupported operating system
#endif

inline bool  tlIsOption(const char *arg) { return arg[0] == gOptionChar; }

/*---------------------------------------------------------------------------
    getopt() - UNIX style command line option parser.
---------------------------------------------------------------------------*/

extern int    _TLXDATA	gOptInd;	// Next argument index
extern int    _TLXDATA	gOptErr;	// Nonzero enables error message
extern char * _TLXDATA	gOptArg;	// Pointer to current option argument

int 	      _TLXFUNC	tlGetOpt(int, char *[], const char *);

/*---------------------------------------------------------------------------
    TLBatchApp -

    Models a typical batch processing program.
---------------------------------------------------------------------------*/

class _TLXCLASS TLBatchApp
{
    int			mDone;		// Set when about to terminate
    int			mRetCode;	// Desired return code

protected:
    int			mArgCnt;	// Number of arguments
    char **		mArgs;		// Command line arguments
    int			mCurArg;	// Current argument
    const char *	mVersion;	// Application version ID

public:
    TLBatchApp(int, char *[], const char *);
    virtual ~TLBatchApp();

    int			Run();
    const char *	Version() const { return mVersion; }

protected:
    // Functions that may be overridden by derived classes
    virtual bool 	PreProcess();
    virtual bool 	PostProcess();
    virtual void	DoFile(const char *);
    virtual void	DoOption(const char *);
    virtual void	PrintLogo();
    virtual void	PrintSyntax();

    // Utility functions for derived classes
    void		Terminate(int);	// Exit in an orderly fashion
    void		Abort(int);	// Exit without postprocessing
    void		SetRetCode(int);
};

#endif	// _TLX_CMDAPP_H
