/****************************************************************************
    $Id: borland.h 501.0 1995/03/07 12:26:40 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Borland-specific declarations of compilation and keyword-like names.

    $Log: borland.h $
    Revision 501.0  1995/03/07 12:26:40  RON
    Updated for TLX 5.01
    Revision 1.8  1995/01/31 16:59:30  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.7  1995/01/28  14:37:36  Ron
    Updated comments to use C++ style

    Revision 1.6  1995/01/18  18:52:37  ron
    Added support for _GUI preprocessor name

    Revision 1.5  1995/01/05  15:32:26  ron
    Various small changes

    Revision 1.4  1994/11/16  15:24:42  ron
    Added _CCNAME, _CCVER, and _MODEL definitions

    Revision 1.3  1994/10/06  17:46:36  ron
    Added _NOMUTABLE

    Revision 1.2  1994/09/08  15:53:09  ron
    Moved O/S-specific macros into this file

    Revision 1.1  1994/08/16  18:06:44  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_BORLAND_H
#define _TLX_BORLAND_H

#ifndef __TURBOC__
#error This file is for Borland compilations only
#endif

#define _CCNAME		Borland C++
#define _CCVER		__TURBOC__

#ifdef __DLL__
#define _IN_DLL		1
#endif

#ifdef _RTLDLL			// Using DLL version of C runtime library
  #ifndef ___DEFS_H
    #include <_defs.h>		// Borland C++ internal RTL definitions
  #endif

  #if defined(_EXPCLASS)	// Borland C++ 4.0, BC++ OS/2
    #define _RTLCLASS	_EXPCLASS
  #elif defined(_CLASSTYPE)	// Borland C++ 3.1
    #define _RTLCLASS	_CLASSTYPE
  #else
    #define _RTLCLASS
  #endif
#endif

#if __TURBOC__ < 0x452
  #define _NORTTI	1
  #define _NOEXCEPT	1
#endif

// For compatbility with BIDS 4.5, we check whether or not we must define
// 'bool' c.s. here, or leave it to BIDS.

#if defined(BI_NO_BOOL)
  #if !defined(CLASSLIB_DEFS_H)
    #error Must #include <classlib\defs.h> before #including this file
  #elif defined(BI_UNIQUE_BOOL)
    #error Unique boolean type requires recompilation of TLX
  #endif
#elif __TURBOC__ < 0x500
  #define _NOBOOL	1
#endif
#define _NOMUTABLE	1

// Assume that all Borland compilers target Intel 80x86 processors

#define _CPU_I86    1
#define _LENDIAN    1
#define _NULL_IS_0  1

#ifdef __FLAT__			// Non-segmented platforms
    #define _MEM_FLAT		1
    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat
#else				// Segmented memory architectures
    #define _MEM_SEG	1
    #define _Near		_near
    #define _Far		_far
    #define _Huge		_huge

    #if __TINY__
	#define _CODE_NEAR	1
	#define _DATA_NEAR	1
    	#define _MODEL		Tiny
    #elif __SMALL__
	#define _CODE_NEAR	1
	#define _DATA_NEAR	1
    	#define _MODEL		Small
    #elif __COMPACT__
	#define _CODE_NEAR	1
	#define _DATA_FAR	1
    	#define _MODEL		Compact
    #elif __MEDIUM__
	#define _CODE_FAR	1
	#define _DATA_NEAR	1
    	#define _MODEL		Medium
    #elif __LARGE__
	#define _CODE_FAR	1
	#define _DATA_FAR	1
    	#define _MODEL		Large
    #elif __HUGE__
	#define _CODE_FAR	1
	#define _DATA_FAR	1
    	#define _MODEL		Huge
    #endif
#endif

#if defined(__OS2__)		// OS/2 2.x - assume BCOS2 1.0 and up

    #define OS_OS2		1

  #ifdef __PM__
    #define _GUI		1
  #endif

    #define _ExportClass	__export
    #define _ExportFunc		__export
    #define _ExportData		__export

    #define _ImportClass
    #define _ImportFunc
    #define _ImportData

#elif defined(__WIN32__)    	// Win32 - assume BC++ 4.0 and up

  #if defined(__DPMI32__)
    #define OS_DOS386   	1
    #define OS_DOSXXX   	1
  #else
    #define OS_WIN32    	1
    #define OS_WINXXX   	1
  #endif

  #ifndef __CONSOLE__
    #define _GUI		1
  #endif

    #define _ExportClass	__export
    #define _ExportFunc		__export
    #define _ExportData		__export

    #define _ImportClass	__import
    #define _ImportFunc		__import
    #define _ImportData		__import

#elif defined(__BCPLUSPLUS__) && __BCPLUSPLUS__ >= 0x320

    // Versions of Borland C++ from 4.0 onwards

    #define _ExportClass	__export
    #define _ExportFunc		__export __far
    #define _ExportData		__export __far

    #define _ImportClass	__import
    #define _ImportFunc		__far
    #define _ImportData		__far

    #if defined(__DPMI16__)
    	#define OS_DOS286   	1
    	#define OS_DOSXXX   	1
    #elif defined(_Windows)
    	#define OS_WIN16    	1
    	#define OS_WINXXX   	1
	#define _GUI	    	1
    #else
    	#define OS_DOS      	1
    	#define OS_DOSXXX   	1
    #endif
#else				// Older versions of Borland compilers

    #define _ExportClass	_export
    #define _ExportFunc		_export _far
    #define _ExportData		_export _far

    #define _ImportClass	_huge
    #define _ImportFunc		_far
    #define _ImportData		_far

    #if defined(_Windows)
    	#define OS_WIN16    	1
    	#define OS_WINXXX   	1
	#define _GUI	    	1
    #else
    	#define OS_DOS      	1
    	#define OS_DOSXXX   	1
    #endif
#endif

#endif	// _TLX_BORLAND_H
